% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TAR.r
\name{rankQ}
\alias{rankQ}
\title{Rank-Based Portmanteau Tests}
\usage{
rankQ(zt, lag = 10, output = TRUE)
}
\arguments{
\item{zt}{time series.}

\item{lag}{the maximum lag to calculate the test statistic.}

\item{output}{a logical value for output. Default is TRUE.}
}
\value{
\code{rankQ} function outputs the test statistics and p-values for Portmanteau tests, and returns a list with components:
\item{Qstat}{test statistics.}
\item{pv}{p-values.}
}
\description{
Performs rank-based portmanteau statistics.
}
\examples{
phi=t(matrix(c(-0.3, 0.5,0.6,-0.3),2,2))
y=uTAR.sim(nob=2000, arorder=c(2,2), phi=phi, d=2, thr=0.2, cnst=c(1,-1),sigma=c(1, 1))
rankQ(y$series,10,output=TRUE)
}
