% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{NNsetting}
\alias{NNsetting}
\title{Setting Up The Predictor Matrix in A Neural Network for Time Series Data}
\usage{
NNsetting(zt, locY = 1, nfore = 0, lags = c(1:5),
  include.lagY = TRUE)
}
\arguments{
\item{zt}{data matrix, including the dependent variable \code{Y(t)}.}

\item{locY}{location of the dependent variable (column number).}

\item{nfore}{number of out-of-sample prediction (1-step ahead).}

\item{lags}{a vector containing the lagged variables used to form the x-matrix.}

\item{include.lagY}{indicator for including lagged \code{Y(t)} in the predictor matrix.}
}
\value{
The function returns a list with following components.
\item{X}{\code{x}-matrix for training a neural network.}
\item{y}{\code{y}-output for training a neural network.}
\item{predX}{\code{x}-matrix for the prediction subsample.}
\item{predY}{\code{y}-output for the prediction subsample.}
}
\description{
The function sets up the predictor matrix in a neural network for time series data.
}
\references{
Tsay, R. and Chen, R. (2018). Nonlinear Time Series Analysis. John Wiley & Sons, New Jersey.
}
