% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/myFUN.R
\name{marg2}
\alias{marg2}
\title{Implements a non-linear least squares based algorithm for estimating signal proportion and density}
\usage{
marg2(y, x, nlslambda = 1e-06/length(y), level = 0.05)
}
\arguments{
\item{y}{The observed vector of z-scores.}

\item{x}{The \eqn{n\times p} data matrix, where \eqn{n} must be equal to thelength of y. If you are interested in the intercept, you must add a column of \eqn{1's} to \eqn{x}.}

\item{nlslambda}{The tolerance threshold while implementing a quasi-Newton approach for the non-linear least squares problem. Default is set to \eqn{1e-6/}length(y). We recommend not changing it unless absolutely sure.}

\item{level}{The level at which the false discovery rate is to be controlled. Should be a scalar in \eqn{[0,1]}. Default set to \eqn{0.05}.}
}
\value{
This function returns a list consisting of the following:

\item{p}{The estimated prior probabilities, i.e., \eqn{\hat\pi(\cdot)} evaluated at the data points.}

\item{b}{The estimates for the coefficient vector in the logistic function.}

\item{f1y}{The vector of estimated signal densities evaluated at the data points.}

\item{kwo}{This is a list with four items - i. \emph{atoms}: The vector of means for the Gaussian distributions used to approximate \eqn{G(\cdot)}, ii. \emph{probs}: The vector of probabilities for each Gaussian component used to approximate \eqn{G(\cdot)}, iii. \emph{f1y}: Same as f1y above, iv. \emph{ll}: The average of the logarithmic values of f1y. }

\item{localfdr}{The vector of estimated local false discovery rates evaluated at the data points.}

\item{den}{The vector of estimated conditional densities evaluated at the data points.}

\item{ll}{The log-likelihood evaluated at the estimated optima.}

\item{rejset}{The vector of \eqn{1}s and \eqn{0}s where \eqn{1} indicates that the corresponding hypothesis is to be rejected.}

\item{pi0}{The average of the entries of the vector \emph{p}.}

\item{ll_list}{The vector of profile log-likelihoods corresponding to a pre-determined set of grid points for \eqn{\mu^*}. The highest element of this vector is the output in \emph{ll}.}
}
\description{
This function estimates the signal proportion and the signal density by using
the conditional mean \eqn{Y|X=x}, followed by a non-linear least squares regression based approach.
It returns the vector of estimated local false discovery rates and the corresponding
rejection set at a prespecified level for the false discovery rate.
}
\details{
Note that the conditional mean of \eqn{Y|X} based on the aforementioned model
is a non-linear function of the parameters, i.e., the logistic coefficients
and the mean of the marginal distribution of \eqn{Y}, \eqn{\mu^* = \mathbf{E}[Y]}.
This is a non-convex optimization problem in the parameters and is solved by varying
\eqn{\mu^*} over a predetermined grid, and optimizing over the logistic coefficients.
This is the estimate of \eqn{\pi^*(\cdot)} from the marg2() method. The estimate of
\eqn{\phi_1(\cdot)} is obtained as in the marg1() method by using the Rmosek optimization
suite, and the same discrete approximation to the mixing distribution \eqn{G(\cdot)}.
}
\references{
Deb, N., Saha, S., Guntuboyina, A. and Sen, B., 2018. Two-component Mixture Model in the Presence of Covariates. arXiv preprint arXiv:1810.07897.

Koenker, R. and Mizera, I., 2014. Convex optimization, shape constraints, compound decisions, and empirical Bayes rules. Journal of the American Statistical Association, 109(506), pp.674-685.
}
