% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TSD.R
\name{NNS.TSD}
\alias{NNS.TSD}
\title{NNS TSD Test}
\usage{
NNS.TSD(x, y, plot = TRUE)
}
\arguments{
\item{x}{a numeric vector.}

\item{y}{a numeric vector.}

\item{plot}{logical; \code{TRUE} (default) plots the TSD test.}
}
\value{
Returns one of the following TSD results: \code{"X TSD Y"}, \code{"Y TSD X"}, or \code{"NO TSD EXISTS"}.
}
\description{
Bi-directional test of third degree stochastic dominance using lower partial moments.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100)
NNS.TSD(x, y)
}
\references{
Viole, F. and Nawrocki, D. (2016) "LPM Density Functions for the Computation of the SD Efficient Set." Journal of Mathematical Finance, 6, 105-126.  DOI: \doi{10.4236/jmf.2016.61012}.
}
\author{
Fred Viole, OVVO Financial Systems
}
