% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepwise-covariate.R
\name{add_remove_covs}
\alias{add_remove_covs}
\alias{add_cov}
\alias{remove_cov}
\title{Add/remove a covariate to a NONMEM model}
\usage{
add_cov(
  ctl,
  param,
  cov,
  state = 2,
  continuous = TRUE,
  time_varying,
  additional_state_text = list(),
  id_var = "ID",
  force = FALSE,
  force_TV_var = FALSE,
  init,
  lower,
  upper
)

remove_cov(
  ctl,
  param,
  cov,
  state = 2,
  continuous = TRUE,
  time_varying,
  id_var = "ID"
)
}
\arguments{
\item{ctl}{An nm object or an object coercible to \code{ctl_list}.}

\item{param}{Character. Name of parameter.}

\item{cov}{Character. Name of covariate.}

\item{state}{Numeric or character. Number or name of state (see details).}

\item{continuous}{Logical (default = \code{TRUE}). Is covariate continuous?}

\item{time_varying}{Optional logical. is the covariate time varying?}

\item{additional_state_text}{Optional character (default = empty). Custom
state variable to be passed to \code{param_cov_text}.}

\item{id_var}{Character (default = \code{"ID"}). Needed if time_varying is
missing.}

\item{force}{Logical (default = `FALSE``). Force covariate in even if missing
values found.}

\item{force_TV_var}{Logical (default = \code{FALSE}). Force covariates only on
\code{TV} notation parameters.}

\item{init}{Optional numeric/character vector.  Initial estimate of
additional parameters.}

\item{lower}{Optional numeric/character vector.  lower bound of additional
parameters.}

\item{upper}{Optional numeric/character vector.  Upper bound of additional
parameters.}
}
\value{
An nm object with modified \code{ctl_contents} field.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Follows PsN coding conventions to add covariates into a model.  The advantage
is no need to create a .scm file, just directly modify the NONMEM control
file contents. This function is used by \code{\link[=covariate_step_tibble]{covariate_step_tibble()}} for
stepwise covariate model development.
}
\details{
Available \code{state}s:

\describe{

\item{"2" or "linear"}{
PARCOV= ( 1 + THETA(1)*(COV -median))
}

\item{"3" or "hockey-stick"}{
IF(COV.LE.median) PARCOV = ( 1 + THETA(1)*(COV - median))
IF(COV.GT.median) PARCOV = ( 1 + THETA(2)*(COV - median))
}

\item{"4" or "exponential"}{
PARCOV= EXP(THETA(1)*(COV - median))
}

\item{"5" or "power"}{
PARCOV= ((COV/median)**THETA(1))
}

\item{"power1"}{
PARCOV= ((COV/median))
}

\item{"power0.75"}{
PARCOV= ((COV/median)**0.75)
}

\item{"6" or "log-linear"}{
PARCOV= ( 1 + THETA(1)*(LOG(COV) - log(median)))
}

}

\code{remove_cov} only works with covariates added with \code{add_cov}.
}
\examples{

# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

temp_data_file <- paste0(tempfile(), ".csv")

## dataset has missing WTs so create a new one and assign this to the run
input_data(m1) \%>\% 
  dplyr::group_by(ID) \%>\%
  dplyr::mutate(WT = na.omit(WT)) \%>\%
  write_derived_data(temp_data_file)
  
m1 <- m1 \%>\% data_path(temp_data_file)
 
m1WT <- m1 \%>\% child("m1WT") \%>\%
  add_cov(param = "V", cov = "WT", state = "power")

m1 \%>\% dollar("PK")
m1WT \%>\% dollar("PK")  ## notice SCM style code added

nm_diff(m1WT)

\dontrun{
run_nm(c(m1, m1WT))
rr(c(m1, m1WT))
summary_wide(c(m1, m1WT)) 
}

unlink(temp_data_file)


# create example object m1 from package demo files
exdir <- system.file("extdata", "examples", "theopp", package = "NMproject")
m1 <- new_nm(run_id = "m1", 
             based_on = file.path(exdir, "Models", "ADVAN2.mod"),
             data_path = file.path(exdir, "SourceData", "THEOPP.csv"))

temp_data_file <- paste0(tempfile(), ".csv")

## dataset has missing WTs so create a new one and assign this to the run
input_data(m1) \%>\% 
  dplyr::group_by(ID) \%>\%
  dplyr::mutate(WT = na.omit(WT)) \%>\%
  write_derived_data(temp_data_file)
  
m1 <- m1 \%>\% data_path(temp_data_file)
 
m1WT <- m1 \%>\% child("m1WT") \%>\%
  add_cov(param = "V", cov = "WT", state = "power")

m1 \%>\% dollar("PK")
m1WT \%>\% dollar("PK")  ## notice SCM style code added

## reverse this by removing WT

m1noWT <- m1WT \%>\% child("m1noWT") \%>\%
  remove_cov(param = "V", cov = "WT") 
  
m1noWT \%>\% dollar("PK")
m1noWT \%>\% dollar("THETA")

unlink(temp_data_file)

}
\seealso{
\code{\link[=covariate_step_tibble]{covariate_step_tibble()}}, \code{\link[=test_relations]{test_relations()}}
}
