% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmAddTSNE}
\alias{chmAddTSNE}
\title{Add TSNE coordinates to an NG-CHM.}
\usage{
chmAddTSNE(hm, axis, tsne, pointIds, basename = "TSNE")
}
\arguments{
\item{hm}{The NGCHM to add the coordinates to}

\item{axis}{The NGCHM axis ("row" or "column") to add the coordinates to}

\item{tsne}{TSNE coordinates (output of \href{https://CRAN.R-project.org/package=Rtsne}{Rtsne::Rtsne()}) for the specified NGCHM axis}

\item{pointIds}{The NGCHM names for the data points in tsne}

\item{basename}{The prefix to use for the coordinate names.}
}
\value{
The NGCHM with added coordinates.
}
\description{
Add TSNE coordinates as hidden covariate bars to an axis of an NG-CHM.  One hidden
covariate bar is added for each TSNE coordinate.  Coordinates have names 'BASENAME.coordinate.N',
where BASENAME is specified by the parameter basename (default TSNE) and N ranges from 1 to the number of
added covariate bars.
}
\details{
pointIds is required because \href{https://CRAN.R-project.org/package=Rtsne}{Rtsne::Rtsne()} does not preserve the rownames of the data matrix it was applied to.
Their values must match those on that axis of the NGCHM, but their order must match those in the data
matrix passed to \href{https://CRAN.R-project.org/package=Rtsne}{Rtsne::Rtsne()}.
}
\examples{
# Examples using  `chmNew()` require git to be installed.
\dontrun{
  # If the NGCHMDemoData package is installed, use it to demo usage
  if (requireNamespace("NGCHMDemoData", quietly = TRUE)) {
    data(TCGA.GBM.EXPR, package = "NGCHMDemoData")
    mat <- TCGA.GBM.EXPR[1:10, 1:10]
    rtc <- Rtsne::Rtsne(t(mat), check_duplicates = FALSE, perplexity = 3)
    hm <- chmNew("gbm", mat)
    hm <- chmAddTSNE(hm, "column", rtc, colnames(mat))
  }
  # Small example not requiring NGCHMDemoData
  matrix <- matrix(rnorm(100),
    nrow = 10, ncol = 10,
    dimnames = list(paste0("r", 1:10), paste0("c", 1:10))
  )
  rtc <- Rtsne::Rtsne(t(matrix), check_duplicates = FALSE, perplexity = 3)
  hm <- chmNew("Demo TSNE", matrix)
  hm <- chmAddTSNE(hm, "column", rtc, colnames(matrix))
}

}
\seealso{
\code{\link[=chmAddPCA]{chmAddPCA()}}

\code{\link[=chmAddUMAP]{chmAddUMAP()}}

\code{\link[=chmAddUWOT]{chmAddUWOT()}}

\code{\link[=chmAddReducedDim]{chmAddReducedDim()}}
}
