% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/NCmisc.R
\name{out.of}
\alias{out.of}
\title{Easily display fraction and percentages}
\usage{
out.of(n, N = 100, digits = 2, pc = TRUE, oo = TRUE, use.sci = FALSE)
}
\arguments{
\item{n}{numeric, the count for the subset of N (the numerator)}

\item{N}{numeric, the total size of the full set (the denominator)}

\item{digits,}{integer, the number of digits to display in the percentage}

\item{pc,}{logical, whether to display the percentage of N that n comprises}

\item{oo,}{logical, whether to display n/N as a fraction}

\item{use.sci,}{logical, whether to allow scientific notation for small/large
percentages.}
}
\value{
A string showing the fraction n/N and percentage (or just one of these)
}
\description{
For a subset 'n' and total 'N', nicely prints text n/N and/or percentage%.
Often we want to display proportions and this simple function reduces the
required amount of code for fraction and percentage reporting. If
insufficient digits are provided small percentage may truncate to zero.
}
\examples{
out.of(345,12144)
out.of(345,12144,pc=FALSE)
out.of(3,10^6,digits=6,oo=FALSE)
out.of(3,10^6,digits=6,oo=FALSE,use.sci=TRUE)
}

