% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpSimulateMissings.R
\name{PipeOpSimulateMissings}
\alias{PipeOpSimulateMissings}
\title{PipeOpSimulateMissings}
\description{
Generates MCAR missing values in mlr3 pipeline according to set parameters.
Missings are inserted to task data once during first training.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpTaskPreproc}}.
}

\section{Parameters}{

\itemize{
\item \code{per_missings} :: \code{double(1)}\cr
Overall percentage of missing values generated in dataset [0, 100]. Must be set every time, default 50%.
\item \code{per_instances_missings} :: \code{double(1)}\cr
Percentage of instances which will have missing values [0, 100].
\item \code{per_variables_missings} :: \code{double(1)}\cr
Percentage of variables which will have missing values [0, 100].
\item \code{variables_missings} :: \code{integer}\cr
Only when `per_variables_missings` is `NULL`. Vector of indexes of columns in which missings will be generated.
}
}

\examples{
{
  task_NA <- PipeOpSimulateMissings$new()$train(list(tsk("iris")))[[1]]

  # check
  sum(task_NA$missings()) > 0
}
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{PipeOpSimulateMissings}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpSimulateMissings-new}{\code{PipeOpSimulateMissings$new()}}
\item \href{#method-PipeOpSimulateMissings-clone}{\code{PipeOpSimulateMissings$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpSimulateMissings-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpSimulateMissings-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpSimulateMissings$new(
  id = "simulate_missings",
  param_vals = list(per_missings = 50)
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpSimulateMissings-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpSimulateMissings-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpSimulateMissings$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
