% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOPVIM_IRMI.R
\name{PipeOpVIM_IRMI}
\alias{PipeOpVIM_IRMI}
\title{PipeOpVIM_IRMI}
\description{
Implements IRMI methods as mlr3 pipeline, more about VIM_IRMI \code{\link{autotune_VIM_Irmi}}.
}
\section{Input and Output Channels}{

Input and output channels are inherited from \code{\link{PipeOpImpute}}.
}

\section{Parameters}{

The parameters include inherited from [`PipeOpImpute`], as well as: \cr
\itemize{
\item \code{id} :: \code{character(1)}\cr
Identifier of resulting object, default \code{"imput_VIM_IRMI"}.
\item \code{eps} :: \code{double(1)}\cr
Threshold for convergence, default \code{5}.
\item \code{maxit} :: \code{integer(1)}\cr
Maximum number of iterations, default \code{100}
\item \code{step} :: \code{logical(1)}\cr
Stepwise model selection is applied when the parameter is set to TRUE, default \code{FALSE}.
\item \code{robust} :: \code{logical(1)}\cr
	If TRUE, robust regression methods will be applied (it's impossible to set step=TRUE and robust=TRUE at the same time), default \code{FALSE}.
\item \code{init.method} :: \code{character(1)}\cr
Method for initialization of missing values (kNN or median), default \code{'kNN'}.
\item \code{force} :: \code{logical(1)}\cr
If TRUE, the algorithm tries to find a solution in any case by using different robust methods automatically (should be set FALSE for simulation), default \code{FALSE}.
\item \code{out_fill} :: \code{character(1)}\cr
Output log file location. If file already exists log message will be added. If NULL no log will be produced, default \code{NULL}.
}
}

\examples{
\donttest{
  graph <- PipeOpVIM_IRMI$new() \%>>\% mlr3learners::LearnerClassifGlmnet$new()
  graph_learner <- GraphLearner$new(graph)

  # Task with NA

  resample(TaskClassif$new('id',tsk('pima')$data(rows=1:100),
  'diabetes'), graph_learner, rsmp("cv",folds=2))
}
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpImpute]{mlr3pipelines::PipeOpImpute}} -> \code{VIM_IRMI_imputation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-VIM_IRMI_imputation-new}{\code{PipeOpVIM_IRMI$new()}}
\item \href{#method-VIM_IRMI_imputation-clone}{\code{PipeOpVIM_IRMI$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VIM_IRMI_imputation-new"></a>}}
\if{latex}{\out{\hypertarget{method-VIM_IRMI_imputation-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpVIM_IRMI$new(
  id = "impute_VIM_IRMI_B",
  eps = 5,
  maxit = 100,
  step = FALSE,
  robust = FALSE,
  init.method = "kNN",
  force = FALSE,
  out_file = NULL
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-VIM_IRMI_imputation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-VIM_IRMI_imputation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpVIM_IRMI$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
