% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deformGrid2d.r
\name{deformGrid2d}
\alias{deformGrid2d}
\title{visualise differences between two superimposed sets of 2D landmarks}
\usage{
deformGrid2d(matrix, tarmatrix, ngrid = 0, lwd = 1, show = c(1:2),
  lines = TRUE, lcol = 1, col1 = 2, col2 = 3, pcaxis = FALSE,
  add = FALSE, wireframe = NULL, margin = 0.2, gridcol = "grey",
  cex1 = 1, cex2 = 1, ...)
}
\arguments{
\item{matrix}{reference matrix containing 2D landmark coordinates or mesh of class "mesh3d"}

\item{tarmatrix}{target matrix containing 2D landmark coordinates or mesh of class "mesh3d"}

\item{ngrid}{number of grid lines to be plotted; ngrid=0 suppresses grid
creation.}

\item{lwd}{width of lines connecting landmarks.}

\item{show}{integer (vector): if c(1:2) both configs will be plotted, show = 1 only plots the reference and show = 2 the target.
plotted. Options are combinations of 1,2 and 3.}

\item{lines}{logical: if TRUE, lines between landmarks will be plotted.}

\item{lcol}{color of lines}

\item{col1}{color of "matrix"}

\item{col2}{color of "tarmat"}

\item{pcaxis}{logical: align grid by shape's principal axes.}

\item{add}{logical: if TRUE, output will be drawn on existing plot.}

\item{wireframe}{list/vector containing row indices to be plotted as wireframe (see \code{\link{lineplot}}.)}

\item{margin}{margin around the bounding box to draw the grid}

\item{gridcol}{color of the grid}

\item{cex1}{control size of points belonging to \code{matrix}}

\item{cex2}{control size of points belonging to \code{tarmatrix}}

\item{...}{additional parameters passed to plot}
}
\description{
visualise differences between two superimposed sets of 2D landmarks by
deforming a square grid based on a thin-plate spline interpolation
}
\examples{
if (require(shapes)) {
proc <- procSym(gorf.dat)
deformGrid2d(proc$mshape,proc$rotated[,,1],ngrid=5,pch=19)
}

}
\seealso{
\code{\link{tps3d}}
}
\author{
Stefan Schlager
}
