% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/virtualMeshScan.r
\name{getOuterViewpoints}
\alias{getOuterViewpoints}
\title{Get viewpoints on a sphere around a 3D mesh}
\usage{
getOuterViewpoints(x, n, inflate = 1.5, radius = NULL, subdivision = 3,
  PCA = FALSE)
}
\arguments{
\item{x}{triangular mesh of class 'mesh3d'}

\item{n}{number of viewpoint to generate}

\item{inflate}{factor for the size of the sphere: \code{inflate=1} means that the sphere around the object just touches the point farthest away from the mesh's centroid.}

\item{radius}{defines a fix radius for the sphere (overrides arg \code{inflate}).}

\item{subdivision}{parameter passed to \code{\link{vcgSphere}}}

\item{PCA}{logical: if TRUE, the sphere will be deformed to match the principle axes of the mesh. NOTE: this may result in the sphere not necessarily completely enclosing the mesh.}
}
\value{
a list containing
\item{viewpoints}{n x 3 matrix containing viewpoints.}
\item{sphere}{sphere from which the points are sampled}
\item{radius}{radius of the sphere}
}
\description{
Get viewpoints on a sphere around a 3D mesh to be used with virtualMeshScan
}
\examples{
data(boneData)
vp <- getOuterViewpoints(skull_0144_ch_fe.mesh,n=100)
\dontrun{
require(rgl)
shade3d(skull_0144_ch_fe.mesh,col="white")
spheres3d(vp$viewpoints)
wire3d(vp$sphere)
}
### Fit to principal axes
vppca <- getOuterViewpoints(skull_0144_ch_fe.mesh,n=100,PCA=TRUE,inflate=1.5)
\dontrun{
require(rgl)
shade3d(skull_0144_ch_fe.mesh,col="white")
spheres3d(vppca$viewpoints)
wire3d(vppca$sphere)
}
}
