% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equidistantCurve.r
\name{sortCurve}
\alias{sortCurve}
\title{sort curvepoints by using the subsequent neighbours}
\usage{
sortCurve(x, k = 5, start = NULL)
}
\arguments{
\item{x}{k x m matrix containing the 2D or 3D coordinates}

\item{k}{number of nearest neighbours to look at. Set high for very irregularly clustered curves.}

\item{start}{integer: which row of x to use as a starting point. If NULL, it is assumed that the curve is open and the point where the angle between the two nearest neighbours is closest will be chosen.}
}
\value{
\item{xsorted}{matrix with coordinates sorted along a curve}
\item{index}{vector containing the sorting indices}
}
\description{
sort curvepoints by using the subsequent neighbours
}
\examples{

## generate a curve from a polynome
x <- c(32,64,96,118,126,144,152.5,158)
y <- c(99.5,104.8,108.5,100,86,64,35.3,15)
fit <- lm(y~poly(x,2,raw=TRUE))
xx <- seq(30,160, length=50)
layout(matrix(1:3,3,1))
curve <- cbind(xx,predict(fit, data.frame(x=xx)))
## permute order
set.seed(42)
plot(curve);lines(curve)
curveunsort <- curve[sample(1:50),]
## now the curve is scrambled
plot(curveunsort);lines(curveunsort,col=2)
curvesort <- sortCurve(curveunsort)
## after sorting lines are nice again
plot(curvesort$xsorted);lines(curvesort$xsorted,col=3)
}
