% Generated by roxygen2 (4.0.0): do not edit by hand
\name{render}
\alias{export}
\alias{export.meshDist}
\alias{render}
\alias{render.matrixDist}
\alias{render.meshDist}
\title{plot or save the results of meshDist}
\usage{
render(x, ...)

\method{render}{meshDist}(x, from = NULL, to = NULL, steps = NULL,
  ceiling = NULL, uprange = NULL, tol = NULL, displace = FALSE,
  shade = TRUE, sign = NULL, add = FALSE, ...)

\method{render}{matrixDist}(x, from = NULL, to = NULL, steps = NULL,
  ceiling = NULL, uprange = NULL, tol = NULL, type = c("s", "p"),
  radius = NULL, displace = FALSE, sign = NULL, add = FALSE, ...)

export(x, ...)

\method{export}{meshDist}(x, file = "default", imagedim = "100x800", ...)
}
\arguments{
\item{x}{object of class meshDist}

\item{from}{numeric: minimum distance to color; default is set to 0 mm}

\item{to}{numeric: maximum distance to color; default is set to the maximum
distance}

\item{steps}{integer: determines how many intermediate colors the color ramp
has.}

\item{ceiling}{logical: if TRUE, the next larger integer of "to" is used}

\item{uprange}{numeric between 0 and 1: restricts "to" to a quantile of
"to", if to is NULL.}

\item{tol}{numeric: threshold to color distances within this threshold
green.}

\item{displace}{logical: if TRUE, displacement vectors between original and
closest points are drawn colored according to the distance.}

\item{shade}{logical: if FALSE, the rendering of the colored surface will be
supressed.}

\item{sign}{logical: request signed distances to be visualised.}

\item{file}{character: filename for mesh and image files produced. E.g.
"mydist" will produce the files mydist.ply and mydist.png}

\item{imagedim}{character of pattern "100x200" where 100 determines the
width and 200 the height of the image.}

\item{type}{character: "s" shows coordinates as spheres, while "p" shows 3D
dots.}

\item{radius}{determines size of spheres; if not specified, optimal radius
size will be estimated by centroid size of the configuration.}

\item{add}{logical: if TRUE, visualization will be added to the rgl window currently in focus}

\item{\dots}{for render.meshDist: additional arguments passed to
\code{\link{shade3d}}. See \code{\link{rgl.material}} for details.}
}
\description{
plot or save the results of meshDist
}
\details{
Visualise or save the results of meshDist to disk.

render.meshDist renders the colored mesh and displays the color ramp and
returns an object of class "meshDist".  export.meshDist exports the colored
mesh as ply file and the color chart as png file.
}
\author{
Stefan Schlager
}
\seealso{
\code{\link{meshDist}}, \code{\link{shade3d}}
}

