% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-import.R
\name{import_txt}
\alias{import_txt}
\title{Imports coordinates from a .txt file}
\usage{
import_txt(txt.paths = .lf.auto(), verbose = FALSE, ...)
}
\arguments{
\item{txt.paths}{a vector of paths corresponding to the .txt files to import. If not
provided (or \code{NULL}), switches to the automatic version, just as in \link{import_jpg}.
See Details there.}

\item{verbose}{logical whether to print progress in the console}

\item{...}{arguments to be passed to \link{read.table}, eg. 'skip', 'dec', etc.}
}
\value{
a list of matrix(ces) of (x; y) coordinates that can be passed to
\link{Out}, \link{Opn} and \link{Ldk}.
}
\description{
A wrapper around \link{read.table} that can be used to import outline/landmark coordinates.
}
\details{
columns are not named in the \code{.txt} files. You can tune this using the \code{...} argument.
Define the \link{read.table} arguments that allow to import a single file, and then
pass them to this function, ie if your \code{.txt} file
has a header (eg ('x', 'y')), do not forget \code{header=TRUE}.
}
\seealso{
babel functions.
}
