% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pkg-misc.R
\name{harm_pow}
\alias{harm_pow}
\title{Calculates harmonic power given a list from e/t/rfourier}
\usage{
harm_pow(xf)
}
\arguments{
\item{xf}{A list with an, bn (and cn, dn) components, typically from a
e/r/tfourier passed on coo_}
}
\value{
Returns a \code{vector} of harmonic power
}
\description{
Given a list with \code{an, bn (and eventually cn and dn)}, returns the
harmonic power.
}
\examples{

data(bot)
ef <- efourier(bot[1], 24)
rf <- efourier(bot[1], 24)
harm_pow(ef)
harm_pow(rf)

plot(cumsum(harm_pow(ef)[-1]), type='o',
  main='Cumulated harmonic power without the first harmonic',
  ylab='Cumulated harmonic power', xlab='Harmonic rank')

}
