% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3b_wrapperFunctions.R
\name{addEffect}
\alias{addEffect}
\title{addEffect}
\usage{
addEffect(effectsObject, effectName, ...)
}
\arguments{
\item{effectsObject}{The monan Effects object to which another
effect should be added.}

\item{effectName}{The name of the effect that should be added (e.g. loops).}

\item{...}{Additional parameters of the effect, for example alpha,
attribute.index, or resource.attribute.index}
}
\value{
An object of type effectsList.monan
}
\description{
A function to add addtional effects to a moman effects object
}
\examples{
# Create effects object and add effects
myE1 <- createEffects(myState)
myE1 <- addEffect(myE1, loops)
myE1 <- addEffect(myE1, reciprocity_basic)
myE1 <- addEffect(myE1, effectName = same_covariate, attribute.index = "region")

# Or simpler
myE1 <- createEffects(myState) |>
  addEffect(loops) |>
  addEffect(reciprocity_basic) |>
  addEffect(same_covariate, attribute.index = "region")
}
