% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{FARI}
\alias{FARI}
\title{Compute the Frobenius (adjusted) Rand index}
\usage{
FARI(z1,
     z2)
}
\arguments{
\item{z1, z2}{A \eqn{n * G}{n * G} matrix representing a hard partition (all entries 0 or 1) or soft cluster-membership probabilities.}
}
\value{
A list with the following named components:
\describe{
\item{\code{FRI}}{Measure of Frobenius Rand index between \code{z1} and \code{z2}.}
\item{\code{FARI}}{Measure of Frobenius adjusted Rand index between \code{z1} and \code{z2}.}
}
}
\description{
This function efficiently computes fuzzy generalisations of the Rand and adjusted Rand indices for comparing two partitions, allowing either or both partitions to be "soft" or "hard".
}
\details{
If \code{z1} &/or \code{z2} is supplied as a vector of cluster labels, they will be coerced to an appropriate matrix via \code{\link[mclust]{unmap}}.
}
\note{
The number of columns of the matrices \code{z1} and \code{z2} need not be equal.
}
\examples{
m1 <- MoE_clust(ais[,3:7], G=2, modelNames="EVE",
                gating=~BMI, expert=~sex, network.data=ais)
m2 <- MoE_clust(ais[,3:7], G=2, modelNames="EVE", 
                equalPro=TRUE, expert=~sex, network.data=ais)
m3 <- MoE_clust(ais[,3:7], G=2, modelNames="VEE", algo="CEM", tau0=0.1)

# FARI between two soft partitions
FARI(m1$z, m2$z)
# FARI between soft and hard partitions
FARI(m1$z, m3$z)
# FARI between soft partition and hard classification
FARI(m1$z, m2$classification)
# FARI between hard partition and hard classification
FARI(m3$z, m3$classification)
# FARI between hard classification and hard classification
FARI(m1$classification, m2$classification)
}
\references{
Andrew, J. L., Browne, R., and Hvingelby, C. D. (2022). On assessments of agreement between fuzzy partitions. \emph{Journal of Classification}, 39(2): 326-342.
}
\seealso{
\code{\link[mclust]{unmap}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@mu.ie}>
}
\keyword{utility}
