% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CO2data}
\alias{CO2data}
\title{GNP and CO2 Data Set}
\format{
This data frame consists of 28 countries and the following variables:\cr
\describe{
\item{\code{GNP}}{The gross product per capita in 1996.}
\item{\code{CO2}}{The estimated carbon dioxide emission per capita in 1996.}
\item{\code{country}}{An abbreviation pertaining to the country measures (e.g. \code{"GRC"} = Greece and \code{"CH"} = Switzerland).}
}
}
\usage{
data(CO2data)
}
\description{
This data set gives the gross national product (GNP) per capita in 1996 for various countries as well as their estimated carbon dioxide (CO2) emission per capita for the same year.
}
\examples{
data(CO2data, package="MoEClust")
plot(CO2data$GNP, CO2data$CO2, type="n", ylab=expression('CO'[2]))
text(CO2data$GNP, CO2data$CO2, CO2data$country)
}
\references{
Hurn, M., Justel, A. and Robert, C. P. (2003) Estimating mixtures of regressions, \emph{Journal of Computational and Graphical Statistics}, 12(1): 55-79.
}
\keyword{datasets}
