% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{MoE_compare}
\alias{MoE_compare}
\alias{print.MoECompare}
\title{Choose the best MoEClust model}
\usage{
MoE_compare(...,
            criterion = c("bic", "icl", "aic"),
            pick = 3L,
            optimal.only = FALSE)

\method{print}{MoECompare}(x,
      index = seq_len(x$pick),
      noise = TRUE,
      digits = 3L,
      ...)
}
\arguments{
\item{...}{One or more objects of class \code{"MoEClust"} outputted by \code{\link{MoE_clust}}. All models must have been fit to the same data set. A single \emph{named} list of such objects can also be supplied. This argument is only relevant for the \code{\link{MoE_compare}} function and will be ignored for the associated \code{print} function.}

\item{criterion}{The criterion used to determine the ranking. Defaults to \code{"bic"}.}

\item{pick}{The (integer) number of models to be ranked and compared. Defaults to \code{3L}. Will be constrained by the number of models within the \code{"MoEClust"} objects supplied via \code{...} if \code{optimal.only} is \code{FALSE}, otherwise constrained simply by the number of \code{"MoEClust"} objects supplied. Setting \code{pick=Inf} is a valid way to select all models.}

\item{optimal.only}{Logical indicating whether to only rank models already deemed optimal within each \code{"MoEClust"} object (\code{TRUE}), or to allow models which were deemed suboptimal enter the final ranking (\code{FALSE}, the default). See \code{details}}

\item{x, index, noise, digits}{Arguments required for the associated \code{print} function:
\describe{
\item{\code{x}}{An object of class \code{"MoECompare"} resulting from a call to \code{\link{MoE_compare}}.}
\item{\code{index}}{A logical or numeric vector giving the indices of the rows of the table of ranked models to print. This defaults to the full set of ranked models. It can be useful when the table of ranked models is large to examine a subset via this \code{index} argument, for display purposes.}
\item{\code{noise}}{A logical which determines whether presence of a noise-component should be indicated by the method employed to estimate the hypervolume (defaults to \code{TRUE}) or, if \code{FALSE}, simply by \code{TRUE}. In the absence of a noise component, \code{FALSE} will be printed regardless. Only relevant if at least one of the models being compared has a noise component.

If any of the compared models do have a noise component, this switch also controls whether the influence (or not) of gating covariates on the noise component's mixing proportion is indicated (either by \code{TRUE} or \code{FALSE} for models with a noise component, or else a blank entry for those without), for the models among those being compared which have gating covariates.}
\item{\code{digits}}{The number of decimal places to round model selection criteria to (defaults to 3).}}}
}
\value{
A list of class \code{"MoECompare"}, for which a dedicated print function exists, containing the following elements (each of length \code{pick}, and ranked according to \code{criterion}, where appropriate):
\item{\code{optimal}}{The single optimal model (an object of class \code{"MoEClust"}) among those supplied, according to the chosen \code{criterion}.}
\item{\code{pick}}{The final number of ranked models. May be different (i.e. less than) the supplied \code{pick} value.}
\item{\code{MoENames}}{The names of the supplied \code{"MoEClust"} objects.}
\item{\code{modelNames}}{The \code{\link[mclust]{mclustModelNames}}.}
\item{\code{G}}{The optimal numbers of components.}
\item{\code{df}}{The numbers of estimated parameters.}
\item{\code{iters}}{The numbers of EM/CEM iterations.}
\item{\code{bic}}{BIC values, ranked according to \code{criterion}.}
\item{\code{icl}}{TCL values, ranked according to \code{criterion}.}
\item{\code{aic}}{AIC values, ranked according to \code{criterion}.}
\item{\code{loglik}}{Maximal log-likelihood values, ranked according to \code{criterion}.}
\item{\code{gating}}{The gating formulas.}
\item{\code{expert}}{The expert formulas.}
\item{\code{equalPro}}{Logical indicating whether mixing proportions were constrained to be equal across components.}
\item{\code{hypvol}}{Hypervolume parameters for the noise component if required, otherwise set to \code{NA} (see \code{\link{MoE_control}}).}
\item{\code{noise}}{Either a logical indicating the presence/absence of a noise component, or the type of noise component fitted (if any). Depends on the supplied value of \code{noise}. Only displayed if at least one of the compared models has a noise component.}
\item{\code{noise.gate}}{Logical indicating whether gating covariates were allowed to influence the noise component's mixing proportion. Only printed for models with a noise component, when at least one of the compared models has gating covariates, and even then only when \code{noise} is supplied as \code{TRUE}.}
}
\description{
Takes one or more sets of MoEClust models fitted by \code{\link{MoE_clust}} and ranks them according to the BIC, ICL, or AIC. It's possible to respect the internal ranking within each set of models, or to discard models within each set which were already deemed sub-optimal.
}
\details{
The purpose of this function is to conduct model selection on \code{"MoEClust"} objects, fit to the same data set, with different combinations of gating/expert network covariates or different initialisation settings.

Model selection will have already been performed in terms of choosing the optimal number of components and GPCM/\pkg{mclust} model type within each supplied set of results, but \code{\link{MoE_compare}} will respect the internal ranking of models when producing the final ranking if \code{optimal.only} is \code{FALSE}: otherwise only those models already deemed optimal within each \code{"MoEClust"} object will be ranked.

As such if two sets of results are supplied when \code{optimal.only} is \code{FALSE}, the 1st, 2nd and 3rd best models could all belong to the first set of results, meaning a model deemed suboptimal according to one set of covariates could be superior to one deemed optimal under another set of covariates.
}
\note{
The \code{criterion} argument here need not comply with the criterion used for model selection within each \code{"MoEClust"} object, but be aware that a mismatch in terms of \code{criterion} \emph{may} require the optimal model to be re-fit in order to be extracted, thereby slowing down \code{\link{MoE_compare}}.

A dedicated \code{print} function exists for objects of class \code{"MoECompare"}.

\code{\link{plot.MoEClust}} and \code{\link{as.Mclust}} can both also be called on objects of class \code{"MoECompare"}.
}
\examples{
data(CO2data)
GNP   <- CO2data[,1]
CO2   <- CO2data[,2]
m1    <- MoE_clust(CO2, G=1:2)
m2    <- MoE_clust(CO2, G=1:2, gating= ~ GNP)
m3    <- MoE_clust(CO2, G=1:2, expert= ~ GNP)
m4    <- MoE_clust(CO2, G=1:2, gating= ~ GNP, expert= ~ GNP)
m5    <- MoE_clust(CO2, G=1:2, equalPro=TRUE)
m6    <- MoE_clust(CO2, G=1:2, expert= ~ GNP, equalPro=TRUE)

# Rank only the optimal models and examine the best model
(comp <- MoE_compare(m1, m2, m3, m4, m5, m6, pick=6, optimal.only=TRUE))
(best <- comp$optimal)
(summ <- summary(best))

# Examine all models visited, including those already deemed suboptimal
# Only print models with expert covariates & more than one component
comp2 <- MoE_compare(m1, m2, m3, m4, m5, m6, pick=18)
print(comp2, comp2$expert != "None" & comp2$G > 1)
}
\references{
K. Murphy and T. B. Murphy (2017). Parsimonious Model-Based Clustering with Covariates. \emph{To appear}. <\href{https://arxiv.org/abs/1711.05632}{arXiv:1711.05632}>.
}
\seealso{
\code{\link{MoE_clust}}, \code{\link[mclust]{mclustModelNames}}, \code{\link{plot.MoEClust}}, \code{\link{as.Mclust}}
}
\author{
Keefe Murphy - <\email{keefe.murphy@ucd.ie}>
}
\keyword{clustering}
\keyword{main}
