% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_div_test.R
\name{var_par_pq}
\alias{var_par_pq}
\title{Partition the Variation of a phyloseq object by 2, 3, or 4 Explanatory Matrices}
\usage{
var_par_pq(
  physeq,
  list_component,
  dist_method = "bray",
  dbrda_computation = TRUE
)
}
\arguments{
\item{physeq}{(required): a \code{\link{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{list_component}{(required) A named list of 2, 3 or four vectors with
names from the \verb{@sam_data} slot.}

\item{dist_method}{(default "bray") the distance used. See
\code{\link[phyloseq:distance]{phyloseq::distance()}} for all available distances or run
\code{\link[phyloseq:distanceMethodList]{phyloseq::distanceMethodList()}}.
For "aitchison" and "robust.aitchison" distance, \code{\link[vegan:vegdist]{vegan::vegdist()}}
function is directly used.}

\item{dbrda_computation}{(logical) Do dbrda computations are runned for each
individual component (each name of the list component) ?}
}
\value{
an object of class "varpart", see \code{\link[vegan:varpart]{vegan::varpart()}}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
The function partitions the variation in otu_table using
distance (Bray per default) with respect to two, three, or four explanatory
tables, using
adjusted R² in redundancy analysis ordination (RDA) or distance-based
redundancy analysis. If response is a single vector, partitioning is by
partial regression. Collinear variables in the explanatory tables do NOT
have to be removed prior to partitioning. See \code{\link[vegan:varpart]{vegan::varpart()}} for more
information.
}
\details{
This function is mainly a wrapper of the work of others.
Please make a reference to \code{vegan::varpart()} if you
use this function.
}
\examples{
\donttest{
if (requireNamespace("vegan")) {
  data_fungi_woNA <-
    subset_samples(data_fungi, !is.na(Time) & !is.na(Height))
  res_var <- var_par_pq(data_fungi_woNA,
    list_component = list(
      "Time" = c("Time"),
      "Size" = c("Height", "Diameter")
    ),
    dbrda_computation = TRUE
  )
}
}
}
\seealso{
\code{\link[=var_par_rarperm_pq]{var_par_rarperm_pq()}}, \code{\link[vegan:varpart]{vegan::varpart()}}, \code{\link[=plot_var_part_pq]{plot_var_part_pq()}}
}
\author{
Adrien Taudière
}
