% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{report.dim}
\alias{report.dim}
\title{report.dim}
\usage{
report.dim(x, header, trailing = "0")
}
\arguments{
\item{x}{numeric data-frame with Nightingale-metabolomics}

\item{header}{string describing the sub-sampling of the NH-metabolomics matrix}

\item{trailing}{number of digits to show}
}
\value{
The report of the NH-metabolomics matrix dimension
}
\description{
Helper function to report on the console the dimension of the NH metabolomics matrix
}
\examples{
\dontrun{
library(MiMIR)

#load the Nightignale metabolomics dataset
metabolic_measures <- read.csv("Nightingale_file_path",header = TRUE, row.names = 1)
#Apply the scaling to the metabolic features
cat(report.dim(x, header=paste0("Pruning samples on 5SD")))
}

}
\references{
This function is constructed to be able to apply the metaboAge as described in:
van den Akker Erik B. et al. (2020) Metabolic Age Based on the BBMRI-NL 1H-NMR Metabolomics Repository as Biomarker of Age-related Disease. Circulation: Genomic and Precision Medicine, 13, 541-547, \url{doi:10.1161/CIRCGEN.119.002610}
}
\seealso{
QCprep, apply.fit, subset_metabolites_overlap, subset_samples_miss, subset_samples_zero, subset_samples_sd, impute_miss, and apply.scale
}
\keyword{internal}
