% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{find_BBMRI_names}
\alias{find_BBMRI_names}
\title{find_BBMRI_names}
\usage{
find_BBMRI_names(names)
}
\arguments{
\item{names}{vector of strings with the metabolic features names to be translated}
}
\value{
data.frame with the uploaded metabolites names on the first column and the BBMRI names on the second column.
}
\description{
Function to translate Nightingale metabolomics alternative metabolite names to the ones used in BBMRI-nl
}
\examples{
library(MiMIR)
library(purrr)

#load the Nightignale metabolomics dataset
metabolic_measures <- synthetic_metabolic_dataset
#Find the metabolites names used in BBMRI-nl
nam<-find_BBMRI_names(colnames(metabolic_measures)) 

}
\references{
This is a function originally created for the package ggforestplot and modified ad hoc for our package
(https://nightingalehealth.github.io/ggforestplot/articles/index.html).
}
