\name{get_mesh_agree_pair}
\alias{get_mesh_agree_pair}
\title{Agreement measures for a single pair of 3D meshes}
\description{Calculates distance-based as well as volume-overlap-based agreement measures for comparing a single pair of 3D meshes.}
\usage{
get_mesh_agree_pair(x, metro, ui, boov=FALSE, do_ui=FALSE, chop=TRUE, ...)
}
\arguments{
  \item{x}{\code{list} of two 3D meshes that should be compared, e.g., a single component of the list generated by \code{\link[MeshAgreement]{get_mesh_pairs}}.}
  \item{metro}{If already available, the distance-based measures as returned by \code{\link[MeshAgreement]{get_mesh_metro_pair}}. Will be generated if missing.}
  \item{ui}{If already available, the mesh union and intersection as returned by \code{\link[MeshAgreement]{get_mesh_ui_pair}}. Will be generated if missing.}
  \item{boov}{\code{logical}. Use package \code{\link[Boov]{MeshesUnion}} / \code{\link[Boov]{MeshesIntersection}} instead of the corresponding \code{\link[cgalMeshes]{cgalMesh}} methods for calculating union/intersection volumes. Depending on the meshes, this may have better performance.}
  \item{do_ui}{\code{logical}. Calculate volume-overlap-based measures from union/intersection volumes. More time intensive than distance-based measures.}
  \item{chop}{\code{logical}. Delete the components from output of \code{\link[Rvcg]{vcgMetro}} that will not be used later on.}
  \item{...}{Options passed to \code{\link[Rvcg]{vcgMetro}}.}
}
\details{Currently, no mesh can be designated gold standard. \code{\link[MeshAgreement]{get_mesh_agree}} calculates the agreement for a list of observer/mesh objects. \code{\link[MeshAgreement]{get_mesh_metro_pair}} calculates the pairwise distances. \code{\link[MeshAgreement]{get_mesh_ui_pair}} calculates the mesh union and intersection. For \code{boov=TRUE}, packages \code{PolygonSoup} and \code{Boov} have to be installed separately.}
\value{
\code{data.frame} with these variables
\item{mesh1}{Name of the first mesh of the pair.}
\item{mesh2}{Name of the second mesh of the pair.}
\item{group}{The grouping variable indicating which pairs belong to the same structure.}
\item{DCOM}{Euclidean distance between the respective center of mass of both meshes.}
\item{HD_max}{Hausdorff distance - worst case, maximum of both directed Hausdorff distances.}
\item{HD_avg}{Hausdorff distance - average, mean of both directed Hausdorff distancess.}
\item{ASD}{Average symmetric surface distance.}
\item{RMSD}{Root mean squared symmetric surface distance.}
\item{JSC}{Jaccard similarity coefficient.}
\item{DSC}{Dice similarity coefficient.}
}
\references{
Fotina et al. Critical discussion of evaluation parameters for inter-observer variability in target definition for radiation therapy. Strahlenther Onkol 2012; 188: 160-167.

Hanna  et al. Geometrical Analysis of Radiotherapy Target Volume Delineation: a Systematic Review of Reported Comparison Methods. Clin Oncol 2010; 22, 515-525.

Heimann et al. Comparison and Evaluation of Methods for Liver Segmentation From CT Datasets. IEEE Trans Med Imaging 2009; 28: 1251-1265.

Sherer et al. Metrics to evaluate the performance of auto-segmentation for radiation treatment planning: A critical review. Radiother Oncol 2021; 160: 185-191.

\url{https://www.cgal.org/}

\url{http://vcg.isti.cnr.it/vcglib/}
}
\seealso{
\code{\link[MeshAgreement]{get_mesh_pairs}},
\code{\link[MeshAgreement]{get_mesh_metro_pair}},
\code{\link[MeshAgreement]{get_mesh_ui_pair}}
}
\examples{
heartL <- mesh3dL_to_cgalMeshL(data_heart_obsL)
pairL  <- get_mesh_pairs(heartL)
get_mesh_agree_pair(pairL[[1]], do_ui=FALSE,
                    nSamples=500L, silent=TRUE)
}
