% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mscmt.r
\name{mscmt}
\alias{mscmt}
\title{Multivariate SCM Using Time Series}
\usage{
mscmt(data, treatment.identifier = NULL, controls.identifier = NULL,
  times.dep = NULL, times.pred = NULL, agg.fns = NULL, placebo = FALSE,
  placebo.with.treated = FALSE, univariate = FALSE,
  univariate.with.dependent = FALSE, check.global = TRUE,
  inner.optim = "wnnlsOpt", inner.opar = list(), outer.optim = "DEoptC",
  outer.par = list(), outer.opar = list(), std.v = c("sum", "mean", "min",
  "max"), alpha = NULL, beta = NULL, gamma = NULL, return.ts = TRUE,
  single.v = FALSE, verbose = TRUE, debug = FALSE, seed = NULL,
  cl = NULL)
}
\arguments{
\item{data}{Typically, a list of matrices with rows corresponding to times 
and columns corresponding to units for all relevant features (dependent as
well as predictor variables, identified by the list elements' names).
This might be the result of converting from a 
\code{\link[base]{data.frame}}
by using function \code{\link{listFromLong}}. 

For convenience, \code{data} may alternatively be the 
result of function \code{\link[Synth]{dataprep}} of package 
\code{'Synth'}. In this case, the parameters \code{treatment.identifier},
\code{controls.identifier}, \code{times.dep}, \code{times.pred}, 
and \code{agg.fns} are ignored, as these input are generated
automatically from \code{data}. The parameters \code{univariate}, 
\code{alpha}, \code{beta}, and \code{gamma} are ignored by fixing them to 
their defaults.
Using results of \code{\link[Synth]{dataprep}} is experimental, because
the automatic generation of input parameters may fail due to lack of 
information contained in results of \code{\link[Synth]{dataprep}}.}

\item{treatment.identifier}{A character scalar containing the name of the 
treated unit. 
Must be contained in the column names of the matrices in \code{data}.}

\item{controls.identifier}{A character vector containing the names of at 
least two control units.
Entries must be contained in the column names of the matrices in \code{data}.}

\item{times.dep}{A matrix with two rows (containing start times in
the first and end times in the second row) and one column for each dependent
variable, where the column names must exactly match the names of the
corresponding dependent variables. 
A sequence of dates with the given start and end times of
\itemize{
\item annual dates, if the format of start/end time is "dddd", e.g. "2016",
\item quarterly dates, if the format of start/end time is "ddddQd", e.g. 
"2016Q1",
\item monthly dates, if the format of start/end time is "dddd?dd", e.g. 
"2016/03" or "2016-10",
}
will be constructed; these dates are looked for in the row names of
the respective matrices in \code{data}.}

\item{times.pred}{A matrix with two rows (containing start times in
the first and end times in the second row) and one column for each predictor
variable, where the column names must exactly match the names of the
corresponding predictor variables.
A sequence of dates with the given start and end times of
\itemize{
\item annual dates, if the format of start/end time is "dddd", e.g. "2016",
\item quarterly dates, if the format of start/end time is "ddddQd", e.g. 
"2016Q1",
\item monthly dates, if the format of start/end time is "dddd?dd", e.g. 
"2016/03" or "2016-10",
}
will be constructed; these dates are looked for in the row names of
the respective matrices in \code{data}.}

\item{agg.fns}{Either \code{NULL} (default) or a character vector containing
one name of an aggregation function for each predictor variable (i.e., each
column of \code{times.pred}). The character string "id" may be used as a
"no-op" aggregation. Each aggregation function must accept a numeric vector
and return either a numeric scalar ("classical" MSCM) or a numeric vector 
(leading to MSCM*T* if length of vector is at least two).}

\item{placebo}{A logical scalar. If \code{TRUE}, a placebo study is 
performed where, apart from the treated unit, each control unit is considered
as treated unit in separate optimizations. Defaults to \code{FALSE}. 
Depending on the number of control units and the complexity of the problem, 
placebo studies may take a long time to finish.}

\item{placebo.with.treated}{A logical scalar. If \code{TRUE}, the treated
unit is included as control unit (for other treated units in placebo 
studies). Defaults to \code{FALSE}.}

\item{univariate}{A logical scalar. If \code{TRUE}, a series of univariate
SCMT optimizations is done (instead of one MSCMT optimization) even if
there is more than one dependent variable. Defaults to \code{FALSE}.}

\item{univariate.with.dependent}{A logical scalar. If \code{TRUE} (and if
\code{univariate} is also \code{TRUE}), all dependent variables (contained
in the column names of \code{times.dep}) apart from the current (real) 
dependent variable are included as predictors in the series of univariate
SCMT optimizations. Defaults to \code{FALSE}.}

\item{check.global}{A logical scalar. If \code{TRUE} (default), a check for
the feasibility of the "global" optimum (where actually no 
restrictions are imposed by the predictor variables) is made before 
starting the actual optimization procedure.}

\item{inner.optim}{A character scalar containing the name of the optimization
method for the inner optimization. Defaults to \code{"wnnlsOpt"}, which
(currently) is the only implementation.}

\item{inner.opar}{A list containing further parameters for the inner 
optimizer. Defaults to the empty list. (For \code{"wnnlsOpt"}, there are no
meaningful further parameters.)}

\item{outer.optim}{A character scalar containing the name of the optimization
method for the outer optimization. Defaults to \code{"DEoptC"}, 
which (currently) is the recommended global optimizer. 
Also supported, apart from others, are the global optimizers \code{"DEoptim"} 
(see \code{\link[DEoptim]{DEoptim}}) and \code{genoud} (see 
\code{\link[rgenoud]{genoud}}). Documentation for these and other optimizers 
will be added in future releases.}

\item{outer.par}{A list containing further parameters for the outer 
optimization procedure. Defaults to the empty list. Entries in this list may 
override the following hard-coded general defaults:
\itemize{
\item \code{lb=1e-8}, corresponding to the lower bound for the ratio of
predictor weights,
\item \code{opt.separate=TRUE}, corresponding
to an improved outer optimization where each predictor is treated as the 
(potentially) most important predictor (i.e. with maximal weight) in 
separate optimizations (one for each predictor).
}}

\item{outer.opar}{A list containing further parameters for the outer 
optimizer. Defaults to the empty list. Entries in this list may override
hard-coded defaults for the individual optimizers. Hard-coded defaults
for \code{\link[rgenoud]{genoud}} are, e.g.: 
\itemize{
\item \code{print.level=0},
\item \code{max.generations=1000},
\item \code{solution.tolerance=1e-12},
\item \code{pop.size=1000},
\item \code{wait.generations=10},
\item \code{boundary.enforcement=2},
\item \code{gradient.check=FALSE},
\item \code{MemoryMatrix=FALSE}.
}}

\item{std.v}{A character scalar containing one of the function names
"sum", "mean", "min", or "max" for the standardization of the predictor 
weights (weights are divided by \code{std.v(weights)} before reporting). 
Defaults to "sum", partial matching allowed.}

\item{alpha}{A numerical vector with weights for the dependent variables
in an MSCMT optimization or \code{NULL} (default). If not \code{NULL},
the length of \code{alpha} must agree with the number of dependent
variables, \code{NULL} is equivalent to weight 1 for all dependent 
variables.}

\item{beta}{Either \code{NULL} (default), a numerical vector, or a list.
If \code{beta} is a numerical vector or a list, its length must agree
with the number of dependent variables. 
\itemize{
\item If \code{beta} is a numerical vector,
the \code{i}th dependent variable is discounted with discount factor 
\code{beta[i]} (the observations of the dependent variables must thus be 
in chronological order!). 
\item If \code{beta} is a list, the components of \code{beta} must be 
numerical vectors with lengths corresponding to the numbers of observations 
for the individual dependent variables. These observations are then 
multiplied with the corresponding component of \code{beta}.
}}

\item{gamma}{Either \code{NULL} (default), a numerical vector, or a list.
If \code{gamma} is a numerical vector or a list, its length must agree
with the number of predictor variables. 
\itemize{
\item If \code{gamma} is a numerical vector,
the output of \code{agg.fns[i]} applied to the \code{i}th predictor variable
is discounted with discount factor \code{gamma[i]} (the output of 
\code{agg.fns[i]} must therefore be in chronological order!). 
\item If \code{gamma} is a list, the components of \code{gamma} must be 
numerical vectors with lengths corresponding to the lengths of the output of 
\code{agg.fns} for the individual predictor variables. The output of 
\code{agg.fns} is then multiplied with the corresponding component of 
\code{gamma}.
}}

\item{return.ts}{A logical scalar. If \code{TRUE} (default), most results are
converted to time series.}

\item{single.v}{A logical scalar. If \code{FALSE} (default), a selection
of feasible (optimal!) predictor weight vectors is generated. If \code{TRUE}, 
only one set of optimal predictor weights is generated.}

\item{verbose}{A logical scalar. If \code{TRUE} (default), output is verbose.}

\item{debug}{A logical scalar. If \code{TRUE}, output is very verbose. 
Defaults to \code{FALSE}.}

\item{seed}{A numerical scalar or \code{NULL}. If not \code{NULL}, the
random number generator is initialized with \code{set.seed(seed)} (see
\link[base]{Random}) before
calling the optimizer. Defaults to \code{NULL}. Beware: the seeds for 
\code{\link[rgenoud]{genoud}} must be set separately (if necessary) via the
list elements \code{int.seed} (default: 53058) and \code{unif.seed}
(default: 812821) of \code{outer.opar}.}

\item{cl}{\code{NULL} (default) or an object of class \code{cluster}
obtained by \code{\link[parallel]{makeCluster}} of package \code{parallel}. 
Placebo studies will make use of the cluster \code{cl} 
(if not \code{NULL}).}
}
\value{
An object of class \code{"mscmt"}, which is essentially a list
containing the results of the estimation and, if applicable, the placebo
study.
The most important list elements are 
\itemize{
\item the weight vector \code{w} for the control units,
\item a matrix \code{v} with weight vectors for the predictors in its 
columns,
\item scalars \code{loss.v} and \code{rmspe} with the dependent loss and its 
square root,
\item a vector \code{loss.w} with the predictor losses corresponding to the
various weight vectors in the columns of \code{v},
\item a list of multivariate time series \code{combined} containing, 
for each dependent and predictor variable, a multivariate time series 
with elements \code{treated} for the actual values of the treated unit,
\code{synth} for the synthesized values and \code{gaps} for the differences.
}
Placebo studies produce a list containing individual results for each 
unit (as treated unit), starting with the original treated unit, as well
as a list element named \code{placebo} with aggregated results for each
dependent and predictor variable.
}
\description{
\code{mscmt} performs the Multivariate Synthetic Control Method Using Time 
Series.
}
\details{
\code{mscmt} combines, if necessary, the preparation of the raw data (which 
is expected to be in "list" format, possibly after conversion from a 
\code{\link[base]{data.frame}}
with function \code{\link{listFromLong}}) and the call to the appropriate
MSCMT optimization procedures (depending on the input parameters).
}
\examples{
\dontrun{
## for examples, see the package vignettes:
browseVignettes(package="MSCMT")
}
}

