% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/user_function.R
\name{mlvsbm_simulate_network}
\alias{mlvsbm_simulate_network}
\title{Create a simulated multilevel network (MLVSBM object)}
\usage{
mlvsbm_simulate_network(
  n,
  Q,
  pi,
  gamma,
  alpha,
  directed,
  affiliation = "uniform",
  distribution = list("bernoulli", "bernoulli"),
  no_empty_org = FALSE,
  no_isolated_node = FALSE
)
}
\arguments{
\item{n}{A list of 2 positive integers,
the number of individuals and organizations.}

\item{Q}{A list of 2 positive integers,
the number of clusters of individuals and organizations.}

\item{pi}{A vector of probabilities of length Q_O,
the mixture parameter for the organizations.}

\item{gamma}{A \eqn{Q_I \times Q_O} matrix with each column summing to one,
the mixture parameters for the individuals}

\item{alpha}{A list of 2 matrices, a \eqn{Q_I \times Q_I} matrix giving the
connectivity probabilities of the individuals and a \eqn{Q_O \times Q_O}
matrix giving the connectivity probabilities of the organizations.}

\item{directed}{A list of 2 logical. Is the individual level a directed
network ? Is the inter-organizational level a directed network?}

\item{affiliation}{The distribution under which the affiliation matrix is
simulated in c("uniform", "preferential").}

\item{distribution}{A list for the distribution of X,
only "bernoulli" is implemented.}

\item{no_empty_org}{A logical with FALSE as default, should
every organizations have at least one affiliated individual?
Needs to have \eqn{n_I \geq n_O}.}

\item{no_isolated_node}{A logical, if TRUE then the network is simulated
again until all nodes are connected.}
}
\value{
An MLVSBM object, a simulated multilevel network with levels,
affiliations and memberships.
}
\description{
Create a simulated multilevel network (MLVSBM object)
}
\examples{
my_mlvsbm <- MLVSBM::mlvsbm_simulate_network(
  n = list(I = 10, O = 20), # Number of nodes for the lower level and the upper level
  Q = list(I = 2, O = 2), # Number of blocks for the lower level and the upper level
  pi = c(.3, .7), # Block proportion for the upper level, must sum to one
  gamma = matrix(c(.9, .2,   # Block proportion for the lower level,
                   .1, .8), # each column must sum to one
                 nrow = 2, ncol = 2, byrow = TRUE),
  alpha = list(I = matrix(c(.8, .2,
                            .2, .1),
                          nrow = 2, ncol = 2, byrow = TRUE), # Connection matrix
               O = matrix(c(.99, .3,
                            .3, .1),
                          nrow = 2, ncol = 2, byrow = TRUE)),# between blocks
  directed = list(I = FALSE, O = FALSE)) # Are the upper and lower level directed
}
