% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m.R
\name{m}
\alias{m}
\title{Mean center}
\usage{
m(x)
}
\arguments{
\item{x}{a numeric matrix or vector.}
}
\value{
\code{m} returns a mean centered version of \code{x}. If \code{x} is
a matrix, the matrix dimensions are preserved.
}
\description{
Mean center a vector or numeric matrix.

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This function resembles \code{base::scale.default}, with the \code{scale}
argument set to \code{FALSE}. This, together with the short function name, is
especially useful when you want to mean center variables in an analysis (e.g.,
using \code{(g)lm}), but you dont want the long form \code{scale(x, scale=FALSE)}
to clutter up the rownames of the parameter estimates or the model anova.
}
\examples{
vals <- matrix(rnorm(24, 15, 10), ncol = 2)
m(vals)
}
\author{
Mathijs Deen
}
