% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadSpectra.R
\name{loadSpectraMzML}
\alias{loadSpectraMzML}
\title{load mzML spectra}
\usage{
loadSpectraMzML(Dir, filter = NA, nameSpectra = TRUE, verbose = TRUE)
}
\arguments{
\item{Dir}{Character, parent directory of spectra.}

\item{filter}{Character vector, filter out spectra which match the given vector.}

\item{nameSpectra}{Logical, if TRUE the spectra in the resulting list will be named according to the dirname.}

\item{verbose}{Logical, print logs to console}
}
\value{
List of MALDIquant::MassSpectra
}
\description{
load mzML spectra
}
\examples{
dataDir <- system.file("extdata", package="MALDIcellassay")

loadSpectraMzML(file.path(dataDir, "Koch2024mzML"))
}
