% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lmn_prof.R
\name{lmn_prof}
\alias{lmn_prof}
\title{Profile loglikelihood for the LMN model.}
\usage{
lmn_prof(suff, noSigma = FALSE)
}
\arguments{
\item{suff}{An object of class \code{lmn_suff} (see \code{\link[=lmn_suff]{lmn_suff()}}).}

\item{noSigma}{Logical. If \code{TRUE} assumes that \code{Sigma = diag(ncol(Y))} is known and therefore not estimated.}
}
\value{
Scalar; the calculated value of the profile loglikelihood.
}
\description{
Calculate the loglikelihood of the LMN model defined in \code{\link[=lmn_suff]{lmn_suff()}} at the MLE \code{Beta = Bhat} and \code{Sigma = Sigma.hat}.
}
\examples{
# generate data
n <- 50
q <- 2
Y <- matrix(rnorm(n*q),n,q) # response matrix
X <- matrix(1,n,1) # covariate matrix
V <- exp(-(1:n)/n) # diagonal variance specification
suff <- lmn_suff(Y, X = X, V = V, Vtype = "diag") # sufficient statistics

# profile loglikelihood
lmn_prof(suff)

# check that it's the same as loglikelihood at MLE
lmn_loglik(Beta = suff$Bhat, Sigma = suff$S/suff$n, suff = suff)
}
