% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SLHD.R
\name{SLHD}
\alias{SLHD}
\title{Sliced Latin Hypercube Design (SLHD)}
\usage{
SLHD(n, k, t, N, T0, rate, Tmin, Imax, p = 50, q = 1, stage2 = FALSE)
}
\arguments{
\item{n}{A positive integer.}

\item{k}{A positive integer.}

\item{t}{A positive integer.}

\item{N}{A positive integer.}

\item{T0}{A positive number.}

\item{rate}{A positive percentage.}

\item{Tmin}{A positive number.}

\item{Imax}{A positive integer.}

\item{p}{A positive integer.}

\item{q}{The default is set to be 1, and it could be either 1 or 2.}

\item{stage2}{The default is set to be FALSE, and it could be either FALSE or TRUE.}
}
\value{
If all inputs are logical, then the output will be a \code{n} by \code{k} LHD.
}
\description{
\code{SLHD} returns a maximin distance LHD constructed by "improved two-stage algorithm" from Ba et al. (2015).
}
\details{
\itemize{
\item \code{n} stands for the number of rows (or run size).
\item \code{k} stands for the number of columns (or the number of factors).
\item \code{t} stands for the number of slices. \code{n}/\code{t} must be an integer, that is, n is divisible by t. Since S(\strong{X}) needs to be 0 for the algorithm to continue, \code{t} must not exceed \code{k} for \code{n} is 9 or larger, and \code{t} must be smaller than \code{k} for \code{n} is smaller than 9. Otherwise, the funtion will never stop.
\item \code{N} stands for the number of iterations.
\item \code{T0} stands for the user-defined initial temperature.
\item \code{rate} stands for temperature decrease rate, and it should be in (0,1). For example, rate=0.25 means the temperature decreases by 25\% each time.
\item \code{Tmin} stands for the minimium temperature allowed. When current temperature becomes smaller or equal to \code{Tmin}, the stopping criterion for current loop is met.
\item \code{Imax} stands for the maximum perturbations the algorithm will try without improvements before temperature is reduced. For the computation complexity consideration, \code{Imax} is recommended to be smaller or equal to 5.
\item \code{p} is the parameter in the phi_p formula, and \code{p} is prefered to be large.
\item If \code{q} is 1 (the default setting), \code{dij} is the rectangular distance. If \code{q} is 2, \code{dij} is the Euclidean distance.
\item If \code{stage2} is FALSE (the default setting), \code{SLHD} will only implement the first stage of the algorithm. If \code{stage2} is TRUE, \code{SLHD} will implement the whole algorithm.
}
}
\note{
As mentioned from the original paper, the first stage plays a much more important role since it optimizes the slice level. More resources should be given to the first stage if computational budgets are limited. Let m=n/t, where m is the number of rows for each slice, if (m)^k >> n, the second stage becomes optional. That is the reason why we add a \code{stage2} parameter to let users decide if the second stage is needed. If \code{stage2} is FALSE, randomly generated \code{\\Pi_l}'s will be used.
}
\examples{
#Try SLHD without stage II: create a 5 by 3 maximin distance LHD, with # of
#slices is 1, # of iterations = 5, initial temperature is set to be 5,
#decrease rate is 20\%, minimium temperature is 1, maximum perturbations the
#algorithm will try without improvements is 3, and p=50
trySLHD1=SLHD(n=5,k=3,t=1,N=5,T0=5,rate=0.2,Tmin=1,Imax=3,p=50,q=1)
trySLHD1
phi_p(trySLHD1,p=50)   #calculate the phi_p of "trySLHD1".

#Try SLHD with stage II
trySLHD2=SLHD(n=5,k=3,t=1,N=5,T0=5,rate=0.2,Tmin=1,Imax=3,p=50,q=1,stage2=TRUE)
trySLHD2
phi_p(trySLHD2,p=50)   #calculate the phi_p of "trySLHD2".
}
\references{
Ba, S., Myers, W.R., and Brenneman, W.A. (2015) Optimal Sliced Latin Hypercube Designs. \emph{Technometrics}, \strong{57}, 479-487.
}
