% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GICcdown_chart.R
\name{plot_GICCdown_chart}
\alias{plot_GICCdown_chart}
\title{Downward CUSUM Control Chart for Gamma Distribution with Guaranteed Performance}
\usage{
plot_GICCdown_chart(
  alpha,
  beta,
  beta_ratio,
  H_delta,
  H_minus,
  n_I,
  n_II,
  faseI = NULL,
  faseII = NULL,
  known_alpha
)
}
\arguments{
\item{alpha}{Shape parameter of the Gamma distribution.}

\item{beta}{Scale parameter of the Gamma distribution.}

\item{beta_ratio}{Ratio between beta and its estimation.}

\item{H_delta}{Increment of the lower control limit (GIC).}

\item{H_minus}{Initial lower control limit of the CUSUM chart.}

\item{n_I}{Sample size in Phase I (if \code{faseI} is not provided).}

\item{n_II}{Sample size in Phase II (if \code{faseII} is not provided).}

\item{faseI}{Data sample from Phase I (numeric vector). If \code{NULL}, it is generated using \code{rgamma()}.}

\item{faseII}{Data sample from Phase II (numeric vector). If \code{NULL}, it is generated using \code{rgamma()}.}

\item{known_alpha}{If \code{TRUE}, a known \code{alpha} is used; if \code{FALSE}, it is estimated.}
}
\value{
A plot showing the evolution of the downward CUSUM statistic, including:
\itemize{
\item The accumulated values of the CUSUM statistic.
\item Control limits with guaranteed performance.
\item A summary of the parameters used in the control chart.
}
}
\description{
This function generates a downward CUSUM control chart for a Gamma distribution,
displaying the evolution of the CUSUM statistic, control limits, and a summary of the parameters.

Based on the approach presented by Madrid‐Alvarez, García‐Díaz, and Tercero‐Gómez (2024),
this implementation allows for the evaluation and visualization of monitored processes
using a CUSUM chart adapted to Gamma distributions with guaranteed performance.

In particular, the function incorporates a Monte Carlo model to simulate the behavior
of the control chart, allowing for the estimation of the Gamma distribution in Phase I
or the use of predefined values. Additionally, it provides a clear graphical representation
of the evolution of the CUSUM statistic, ensuring appropriate calibration and process control.
\subsection{\strong{Recommendations}}{

To reference specific values of \code{H_delta} and \code{H_minus}, it is recommended to consult the following article:
Madrid‐Alvarez, H. M., García‐Díaz, J. C., & Tercero‐Gómez, V. G. (2024).
\strong{A CUSUM control chart for gamma distribution with guaranteed performance}.
Quality and Reliability Engineering International, 40(3), 1279-1301.
}

\subsection{Features:}{
\itemize{
\item Based on a Monte Carlo model.
\item The Gamma distribution is either estimated in Phase I or predefined values are used.
\item Accumulated values of the CUSUM statistic with guaranteed performance are plotted.
\item Control limits and a summary table are included.
}
}
}
\examples{
# Option 1: Automatically generate data with defined sample sizes
plot_GICCdown_chart(
                    alpha = 3, beta = 1, beta_ratio = 1/2, H_delta = 0.9596,
                    H_minus = -4.6901,n_I = 100, n_II = 200, faseI = NULL,
                    faseII = NULL, known_alpha = FALSE
                    )

# Option 2: Use custom data
phaseI_data <- rgamma(n = 100, shape = 1, scale = 1)
phaseII_data <- rgamma(n = 200, shape = 1, scale = 1)
plot_GICCdown_chart(
                    alpha = 1, beta = 1, beta_ratio = 1/2, H_delta = 2.9693,
                    H_minus = -6.5081, n_I = 100, n_II = 200,
                    faseI = phaseI_data, faseII = phaseII_data,
                    known_alpha = TRUE
                    )

}
