/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.kr.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.lucene.analysis.kr.morph.MorphException;
import org.apache.lucene.analysis.kr.utils.FileUtil;

public class KoreanEnv {
    public static final String FILE_SYLLABLE_FEATURE = "syllable.dic";
    public static final String FILE_DICTIONARY = "dictionary.dic";
    public static final String FILE_JOSA = "josa.dic";
    public static final String FILE_EOMI = "eomi.dic";
    public static final String FILE_EXTENSION = "extension.dic";
    public static final String FILE_PREFIX = "prefix.dic";
    public static final String FILE_SUFFIX = "suffix.dic";
    public static final String FILE_COMPOUNDS = "compounds.dic";
    public static final String FILE_UNCOMPOUNDS = "uncompounds.dic";
    public static final String FILE_CJ = "cj.dic";
    public static final String FILE_KOREAN_PROPERTY = "org/apache/lucene/analysis/kr/korean.properties";
    private Properties defaults = null;
    private Properties props = null;
    private static KoreanEnv instance = null;

    private KoreanEnv() throws MorphException {
        try {
            this.initDefaultProperties();
            this.props = this.loadProperties(this.defaults);
        }
        catch (MorphException e) {
            throw new MorphException("Failure while initializing property values:\n" + e.getMessage());
        }
    }

    public static KoreanEnv getInstance() throws MorphException {
        if (instance == null) {
            instance = new KoreanEnv();
        }
        return instance;
    }

    private void initDefaultProperties() {
        this.defaults = new Properties();
        this.defaults.setProperty(FILE_SYLLABLE_FEATURE, "org/apache/lucene/analysis/kr/dic/syllable.dic");
        this.defaults.setProperty(FILE_DICTIONARY, "org/apache/lucene/analysis/kr/dic/dictionary.dic");
        this.defaults.setProperty(FILE_DICTIONARY, "org/apache/lucene/analysis/kr/dic/extension.dic");
        this.defaults.setProperty(FILE_JOSA, "org/apache/lucene/analysis/kr/dic/josa.dic");
        this.defaults.setProperty(FILE_EOMI, "org/apache/lucene/analysis/kr/dic/eomi.dic");
        this.defaults.setProperty(FILE_PREFIX, "org/apache/lucene/analysis/kr/dic/prefix.dic");
        this.defaults.setProperty(FILE_SUFFIX, "org/apache/lucene/analysis/kr/dic/suffix.dic");
        this.defaults.setProperty(FILE_COMPOUNDS, "org/apache/lucene/analysis/kr/dic/compounds.dic");
        this.defaults.setProperty(FILE_UNCOMPOUNDS, "org/apache/lucene/analysis/kr/dic/uncompounds.dic");
        this.defaults.setProperty(FILE_CJ, "org/apache/lucene/analysis/kr/dic/cj.dic");
    }

    private Properties loadProperties(Properties def) throws MorphException {
        Properties properties = new Properties();
        if (def != null) {
            properties = new Properties(def);
        }
        File file = null;
        try {
            file = FileUtil.getClassLoaderFile(FILE_KOREAN_PROPERTY);
            if (file != null) {
                properties.load(new FileInputStream(file));
                return properties;
            }
            byte[] in = FileUtil.readByteFromCurrentJar(FILE_KOREAN_PROPERTY);
            properties.load(new ByteArrayInputStream(in));
        }
        catch (Exception e) {
            throw new MorphException("Failure while trying to load properties file " + file.getPath(), e);
        }
        return properties;
    }

    public String getValue(String name) {
        return this.props.getProperty(name);
    }
}

