/*
 * Decompiled with CFR 0.152.
 */
package kr.ac.kaist.swrc.jhannanum.demo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import kr.ac.kaist.swrc.jhannanum.hannanum.Workflow;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.MorphAnalyzer.ChartMorphAnalyzer.ChartMorphAnalyzer;
import kr.ac.kaist.swrc.jhannanum.plugin.MajorPlugin.PosTagger.HmmPosTagger.HMMTagger;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.SimpleMAResult09.SimpleMAResult09;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.SimpleMAResult22.SimpleMAResult22;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.MorphemeProcessor.UnknownMorphProcessor.UnknownProcessor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.InformalSentenceFilter.InformalSentenceFilter;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PlainTextProcessor.SentenceSegmentor.SentenceSegmentor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.NounExtractor.NounExtractor;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.SimplePOSResult09.SimplePOSResult09;
import kr.ac.kaist.swrc.jhannanum.plugin.SupplementPlugin.PosProcessor.SimplePOSResult22.SimplePOSResult22;
import kr.ac.kaist.swrc.jhannanum.share.JSONReader;
import org.json.JSONException;

public class GUIDemo {
    private JFrame mainFrame = null;
    private JMenuBar menuBar = null;
    private JMenu menuFile = null;
    private JMenu menuHelp = null;
    private JMenuItem menuItemFileOpen = null;
    private JMenuItem menuItemHelp = null;
    private JTree tree;
    private HashMap<String, String> pluginInfoMap = null;
    private JList listPluginMajor2 = null;
    private JList listPluginMajor3 = null;
    private JList listPluginSupplement1 = null;
    private JList listPluginSupplement2 = null;
    private JList listPluginSupplement3 = null;
    private DefaultListModel listModelMajor2 = null;
    private DefaultListModel listModelMajor3 = null;
    private DefaultListModel listModelSupplement1 = null;
    private DefaultListModel listModelSupplement2 = null;
    private DefaultListModel listModelSupplement3 = null;
    private JTextArea areaPluginInfo = null;
    private JTextArea inputTextArea = null;
    private JTextArea outputTextArea = null;
    private JSplitPane splitPaneTop = null;
    private JSplitPane splitPaneBottom = null;
    private JRadioButton radioMultiThread = null;
    private JRadioButton radioSingleThread = null;
    private JButton buttonActivate = null;
    private JButton buttonAnalysis = null;
    private JButton buttonReset = null;
    private PluginInfo selectedPlugin = null;
    private PluginInfo tempPlugin = null;
    private boolean multiThreadMode = true;
    private boolean activated = false;
    private Workflow workflow = null;

    public static void main(String[] args) {
        GUIDemo demo = new GUIDemo();
        demo.run();
    }

    public void run() {
        this.mainFrame = new JFrame();
        Toolkit kit = this.mainFrame.getToolkit();
        Dimension windowSize = kit.getScreenSize();
        this.mainFrame.setBounds(windowSize.width / 20, windowSize.height / 20, windowSize.width * 18 / 20, windowSize.height * 18 / 20);
        this.mainFrame.setDefaultCloseOperation(2);
        this.mainFrame.setTitle("HanNanum Korean Morphological Analyzer - A Plug-in Component based System (GUI Demo)");
        Font font = new Font("MonoSpaced", 0, 12);
        UIManager.put("TextArea.font", font);
        this.mainFrame.setLayout(new BorderLayout());
        this.mainFrame.getContentPane().add((Component)this.createPaneCenter(), "Center");
        this.mainFrame.getContentPane().add((Component)this.createPaneNorth(), "North");
        this.menuBar = new JMenuBar();
        this.menuFile = new JMenu("File");
        this.menuItemFileOpen = new JMenuItem("Open", 79);
        this.menuHelp = new JMenu("Help");
        this.menuItemHelp = new JMenuItem("Help", 72);
        this.menuItemFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, 8));
        this.menuItemHelp.setAccelerator(KeyStroke.getKeyStroke(72, 8));
        this.menuBar.add(this.menuFile);
        this.menuBar.add(this.menuHelp);
        this.menuFile.add(this.menuItemFileOpen);
        this.menuHelp.add(this.menuItemHelp);
        this.mainFrame.setJMenuBar(this.menuBar);
        this.menuItemFileOpen.addActionListener(new SharedActionHandler());
        this.menuItemHelp.addActionListener(new SharedActionHandler());
        this.buttonActivate.addActionListener(new SharedActionHandler());
        this.buttonAnalysis.addActionListener(new SharedActionHandler());
        this.buttonReset.addActionListener(new SharedActionHandler());
        this.radioMultiThread.addActionListener(new SharedActionHandler());
        this.radioSingleThread.addActionListener(new SharedActionHandler());
        this.listPluginMajor2.addMouseListener(new PluginListMouseListener(this.listPluginMajor2, this.listModelMajor2));
        this.listPluginMajor3.addMouseListener(new PluginListMouseListener(this.listPluginMajor3, this.listModelMajor3));
        this.listPluginSupplement1.addMouseListener(new PluginListMouseListener(this.listPluginSupplement1, this.listModelSupplement1));
        this.listPluginSupplement2.addMouseListener(new PluginListMouseListener(this.listPluginSupplement2, this.listModelSupplement2));
        this.listPluginSupplement3.addMouseListener(new PluginListMouseListener(this.listPluginSupplement3, this.listModelSupplement3));
        this.listPluginMajor2.setTransferHandler(new PluginTransferHandler(2, 1));
        this.listPluginMajor3.setTransferHandler(new PluginTransferHandler(3, 1));
        this.listPluginSupplement1.setTransferHandler(new PluginTransferHandler(1, 2));
        this.listPluginSupplement2.setTransferHandler(new PluginTransferHandler(2, 2));
        this.listPluginSupplement3.setTransferHandler(new PluginTransferHandler(3, 2));
        this.listPluginSupplement1.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginSupplement2.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginSupplement3.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginMajor2.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginMajor3.setDropMode(DropMode.ON_OR_INSERT);
        this.listPluginMajor2.getSelectionModel().setSelectionMode(0);
        this.listPluginMajor3.getSelectionModel().setSelectionMode(0);
        this.listPluginSupplement1.getSelectionModel().setSelectionMode(0);
        this.listPluginSupplement2.getSelectionModel().setSelectionMode(0);
        this.listPluginSupplement3.getSelectionModel().setSelectionMode(0);
        this.listPluginMajor2.setDragEnabled(true);
        this.listPluginMajor3.setDragEnabled(true);
        this.listPluginSupplement1.setDragEnabled(true);
        this.listPluginSupplement2.setDragEnabled(true);
        this.listPluginSupplement3.setDragEnabled(true);
        this.tree.setDragEnabled(true);
        this.tempPlugin = new PluginInfo("", 0, 0);
        this.workflow = new Workflow();
        this.mainFrame.setVisible(true);
        int i = 0;
        while (i < this.tree.getRowCount()) {
            this.tree.expandRow(i);
            ++i;
        }
        this.splitPaneTop.setDividerLocation(0.3);
        this.splitPaneBottom.setDividerLocation(0.5);
    }

    private JComponent createPaneNorth() {
        this.splitPaneTop = new JSplitPane(1);
        this.splitPaneTop.setLeftComponent(this.createPluginPool());
        this.splitPaneTop.setRightComponent(this.createWorkflow());
        this.splitPaneTop.setOneTouchExpandable(true);
        return this.splitPaneTop;
    }

    private JComponent createPluginPool() {
        DefaultMutableTreeNode top = new DefaultMutableTreeNode("HanNanum Plug-in Pool");
        this.createPluginNodes(top);
        this.loadPluginInformation();
        this.tree = new JTree(top);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new PluginTreeSelectionListener());
        this.tree.putClientProperty("JTree.lineStyle", "Horizontal");
        JScrollPane treeView = new JScrollPane(this.tree);
        return treeView;
    }

    private void createPluginNodes(DefaultMutableTreeNode top) {
        DefaultMutableTreeNode phase = null;
        DefaultMutableTreeNode type = null;
        phase = new DefaultMutableTreeNode("Phase1 Plug-in. Plain Text Processing");
        type = new DefaultMutableTreeNode("Supplement Plugin");
        type.add(new DefaultMutableTreeNode(new PluginInfo("InformalSentenceFilter", 1, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("SentenceSegmentor", 1, 2)));
        phase.add(type);
        top.add(phase);
        phase = new DefaultMutableTreeNode("Phase2 Plug-in. Morphological Analysis");
        type = new DefaultMutableTreeNode("Major Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("ChartMorphAnalyzer", 2, 1)));
        phase.add(type);
        type = new DefaultMutableTreeNode("Supplement Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("UnknownMorphProcessor", 2, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("SimpleMAResult09", 2, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("SimpleMAResult22", 2, 2)));
        phase.add(type);
        top.add(phase);
        phase = new DefaultMutableTreeNode("Phase3 Plug-in. Part Of Speech Tagging");
        type = new DefaultMutableTreeNode("Major Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("HmmPosTagger", 3, 1)));
        phase.add(type);
        type = new DefaultMutableTreeNode("Supplement Plug-in");
        type.add(new DefaultMutableTreeNode(new PluginInfo("NounExtractor", 3, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("SimplePOSResult09", 3, 2)));
        type.add(new DefaultMutableTreeNode(new PluginInfo("SimplePOSResult22", 3, 2)));
        phase.add(type);
        top.add(phase);
    }

    private void loadPluginInformation() {
        try {
            this.pluginInfoMap = new HashMap();
            this.pluginInfoMap.put("InformalSentenceFilter", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PlainTextProcessor/InformalSentenceFilter.json"));
            this.pluginInfoMap.put("SentenceSegmentor", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PlainTextProcessor/SentenceSegmentor.json"));
            this.pluginInfoMap.put("ChartMorphAnalyzer", this.getPluginAbstarct("conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json"));
            this.pluginInfoMap.put("UnknownMorphProcessor", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/UnknownMorphProcessor.json"));
            this.pluginInfoMap.put("SimpleMAResult09", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/SimpleMAResult09.json"));
            this.pluginInfoMap.put("SimpleMAResult22", this.getPluginAbstarct("conf/plugin/SupplementPlugin/MorphemeProcessor/SimpleMAResult22.json"));
            this.pluginInfoMap.put("HmmPosTagger", this.getPluginAbstarct("conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json"));
            this.pluginInfoMap.put("NounExtractor", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PosProcessor/NounExtractor.json"));
            this.pluginInfoMap.put("SimplePOSResult09", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PosProcessor/SimplePOSResult09.json"));
            this.pluginInfoMap.put("SimplePOSResult22", this.getPluginAbstarct("conf/plugin/SupplementPlugin/PosProcessor/SimplePOSResult22.json"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getPluginAbstarct(String filePath) throws JSONException, IOException {
        JSONReader json = new JSONReader(filePath);
        String res = null;
        res = String.format("* Name: %s\n* Type: %s\n* Version: %s\n* Author: %s\n* Description: %s\n", json.getName(), json.getType(), json.getVersion(), json.getAuthor(), json.getDescription());
        return res;
    }

    private JComponent createWorkflow() {
        JPanel workflowPanel = new JPanel(new GridLayout(1, 3));
        this.listModelMajor2 = new DefaultListModel();
        this.listModelMajor3 = new DefaultListModel();
        this.listModelSupplement1 = new DefaultListModel();
        this.listModelSupplement2 = new DefaultListModel();
        this.listModelSupplement3 = new DefaultListModel();
        this.listPluginMajor2 = new JList(this.listModelMajor2);
        this.listPluginMajor3 = new JList(this.listModelMajor3);
        this.listPluginSupplement1 = new JList(this.listModelSupplement1);
        this.listPluginSupplement2 = new JList(this.listModelSupplement2);
        this.listPluginSupplement3 = new JList(this.listModelSupplement3);
        JPanel phasePanel = new JPanel(new GridLayout(1, 1));
        phasePanel.setBorder(BorderFactory.createTitledBorder("Phase1. Plain Text Processing"));
        JPanel listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Supplement Plug-in"));
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginSupplement1);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        workflowPanel.add(phasePanel);
        phasePanel = new JPanel(new GridLayout(1, 2));
        phasePanel.setBorder(BorderFactory.createTitledBorder("Phase2. Morphological Analysis"));
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Major Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginMajor2);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Supplement Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginSupplement2);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        workflowPanel.add(phasePanel);
        phasePanel = new JPanel(new GridLayout(1, 2));
        phasePanel.setBorder(BorderFactory.createTitledBorder("Phase3. Part Of Speech Tagging"));
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Major Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginMajor3);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        listPanel = new JPanel(new GridLayout(1, 1));
        listPanel.setBorder(BorderFactory.createTitledBorder("Supplement Plug-in"));
        scroll = new JScrollPane();
        scroll.setViewportView(this.listPluginSupplement3);
        listPanel.add(scroll);
        phasePanel.add(listPanel);
        workflowPanel.add(phasePanel);
        JPanel controlPanel = new JPanel(new GridLayout(4, 1));
        controlPanel.setBorder(BorderFactory.createTitledBorder("Workflow Control"));
        this.buttonActivate = new JButton("Activate the workflow");
        this.buttonAnalysis = new JButton("Analyze Text");
        this.buttonReset = new JButton("Close the workflow");
        JPanel threadPanel = new JPanel(new GridLayout(1, 1));
        this.radioMultiThread = new JRadioButton("Mutli-thread Mode", true);
        this.radioSingleThread = new JRadioButton("Single-thread Mode", false);
        threadPanel.setBorder(BorderFactory.createTitledBorder("Thread Mode"));
        threadPanel.add(this.radioMultiThread);
        threadPanel.add(this.radioSingleThread);
        ButtonGroup groupThread = new ButtonGroup();
        groupThread.add(this.radioMultiThread);
        groupThread.add(this.radioSingleThread);
        controlPanel.add(threadPanel);
        controlPanel.add(this.buttonActivate);
        controlPanel.add(this.buttonAnalysis);
        controlPanel.add(this.buttonReset);
        this.buttonAnalysis.setEnabled(false);
        this.buttonReset.setEnabled(false);
        JPanel pluginInfoPanel = new JPanel(new GridLayout(1, 1));
        pluginInfoPanel.setBorder(BorderFactory.createTitledBorder("Plug-in Information"));
        this.areaPluginInfo = new JTextArea();
        this.areaPluginInfo.setLineWrap(true);
        scroll = new JScrollPane();
        scroll.setViewportView(this.areaPluginInfo);
        pluginInfoPanel.add(scroll);
        JPanel infoPanel = new JPanel(new GridLayout(1, 2));
        infoPanel.add(pluginInfoPanel);
        infoPanel.add(controlPanel);
        JPanel panel = new JPanel(new GridLayout(2, 1));
        workflowPanel.setBorder(BorderFactory.createTitledBorder("HanNanum Workflow"));
        panel.add(workflowPanel);
        panel.add(infoPanel);
        return panel;
    }

    private JComponent createPaneCenter() {
        this.splitPaneBottom = new JSplitPane(1);
        JPanel panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Input Text"));
        this.inputTextArea = new JTextArea();
        JScrollPane scroll = new JScrollPane();
        scroll.setViewportView(this.inputTextArea);
        panel.add(scroll);
        this.splitPaneBottom.setLeftComponent(panel);
        panel = new JPanel(new GridLayout(1, 1));
        panel.setBorder(BorderFactory.createTitledBorder("Result"));
        this.outputTextArea = new JTextArea();
        scroll = new JScrollPane();
        scroll.setViewportView(this.outputTextArea);
        panel.add(scroll);
        this.splitPaneBottom.setRightComponent(panel);
        this.splitPaneBottom.setOneTouchExpandable(true);
        return this.splitPaneBottom;
    }

    private class PluginInfo {
        public static final int PHASE1 = 1;
        public static final int PHASE2 = 2;
        public static final int PHASE3 = 3;
        public static final int MAJOR = 1;
        public static final int SUPPLEMENT = 2;
        public String name = null;
        public int phase = 0;
        public int type = 0;

        public PluginInfo(String name, int phase, int type) {
            this.name = name;
            this.phase = phase;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }
    }

    private class PluginListMouseListener
    implements MouseListener {
        private JList list = null;
        private DefaultListModel listModel = null;

        public PluginListMouseListener(JList list, DefaultListModel listModel) {
            this.list = list;
            this.listModel = listModel;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (e.getClickCount() == 2) {
                this.listModel.remove(this.list.locationToIndex(e.getPoint()));
            } else {
                try {
                    GUIDemo.this.areaPluginInfo.setText((String)GUIDemo.this.pluginInfoMap.get((String)this.listModel.get(this.list.locationToIndex(e.getPoint()))));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }
    }

    private class PluginTransferHandler
    extends TransferHandler {
        private static final long serialVersionUID = 1L;
        private int phase = 0;
        private int type = 0;

        public PluginTransferHandler(int phase, int type) {
            this.phase = phase;
            this.type = type;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            return !GUIDemo.this.activated && GUIDemo.this.selectedPlugin != null && this.phase == ((GUIDemo)GUIDemo.this).selectedPlugin.phase && this.type == ((GUIDemo)GUIDemo.this).selectedPlugin.type;
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            if (!info.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
            DefaultListModel listModel = null;
            int index = dl.getIndex();
            switch (((GUIDemo)GUIDemo.this).selectedPlugin.phase) {
                case 1: {
                    listModel = (DefaultListModel)GUIDemo.this.listPluginSupplement1.getModel();
                    break;
                }
                case 2: {
                    if (((GUIDemo)GUIDemo.this).selectedPlugin.type == 1) {
                        listModel = (DefaultListModel)GUIDemo.this.listPluginMajor2.getModel();
                        listModel.clear();
                        index = 0;
                        break;
                    }
                    if (((GUIDemo)GUIDemo.this).selectedPlugin.type != 2) break;
                    listModel = (DefaultListModel)GUIDemo.this.listPluginSupplement2.getModel();
                    break;
                }
                case 3: {
                    if (((GUIDemo)GUIDemo.this).selectedPlugin.type == 1) {
                        listModel = (DefaultListModel)GUIDemo.this.listPluginMajor3.getModel();
                        listModel.clear();
                        index = 0;
                        break;
                    }
                    if (((GUIDemo)GUIDemo.this).selectedPlugin.type != 2) break;
                    listModel = (DefaultListModel)GUIDemo.this.listPluginSupplement3.getModel();
                }
            }
            if (listModel == null) {
                return false;
            }
            try {
                Transferable t = info.getTransferable();
                String data = (String)t.getTransferData(DataFlavor.stringFlavor);
                int pIndex = listModel.indexOf(data);
                listModel.add(index, data);
                if (pIndex != -1) {
                    if (pIndex >= index) {
                        ++pIndex;
                    }
                    listModel.remove(pIndex);
                }
            }
            catch (Exception e) {
                return false;
            }
            return false;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            JList list = (JList)c;
            Object[] values = list.getSelectedValues();
            StringBuffer buff = new StringBuffer();
            if (values.length >= 0) {
                Object val = values[0];
                buff.append(val);
            }
            ((GUIDemo)GUIDemo.this).tempPlugin.name = buff.toString();
            ((GUIDemo)GUIDemo.this).tempPlugin.phase = this.phase;
            ((GUIDemo)GUIDemo.this).tempPlugin.type = this.type;
            GUIDemo.this.selectedPlugin = GUIDemo.this.tempPlugin;
            return new StringSelection(buff.toString());
        }
    }

    private class PluginTreeSelectionListener
    implements TreeSelectionListener {
        private PluginTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)GUIDemo.this.tree.getLastSelectedPathComponent();
            if (node == null) {
                GUIDemo.this.selectedPlugin = null;
                return;
            }
            Object nodeInfo = node.getUserObject();
            if (node.isLeaf()) {
                GUIDemo.this.selectedPlugin = (PluginInfo)nodeInfo;
                GUIDemo.this.areaPluginInfo.setText((String)GUIDemo.this.pluginInfoMap.get(((GUIDemo)GUIDemo.this).selectedPlugin.name));
            } else {
                GUIDemo.this.selectedPlugin = null;
            }
        }
    }

    private class SharedActionHandler
    implements ActionListener {
        private SharedActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object source = e.getSource();
                if (source == GUIDemo.this.menuItemFileOpen) {
                    this.fileOpen();
                } else if (source == GUIDemo.this.menuItemHelp) {
                    this.help();
                } else if (source == GUIDemo.this.buttonActivate) {
                    this.initWorkflow();
                    this.activateWorkflow();
                } else if (source == GUIDemo.this.buttonAnalysis) {
                    this.analyzeText();
                } else if (source == GUIDemo.this.buttonReset) {
                    this.reset();
                } else if (source == GUIDemo.this.radioMultiThread) {
                    GUIDemo.this.multiThreadMode = true;
                } else if (source == GUIDemo.this.radioSingleThread) {
                    GUIDemo.this.multiThreadMode = false;
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }

        private void fileOpen() {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            chooser.setFileSelectionMode(0);
            chooser.setAcceptAllFileFilterUsed(false);
            if (chooser.showOpenDialog(GUIDemo.this.mainFrame) == 0) {
                File selectedFile = chooser.getSelectedFile();
                try {
                    BufferedReader br = new BufferedReader(new FileReader(selectedFile));
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        GUIDemo.this.inputTextArea.append(String.valueOf(line) + "\n");
                    }
                    br.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        private void help() {
            String helpStr = "  This is a GUI-based demo program of the HanNanum that helps users to understand the concept\nof work flow and use the HanNanum library easily. This consists of components for plug-in pool,\nwork flow, plug-in information, work flow controls, input text and analysis result. Users can\neasily set up various work flows by drag-and-drop the plug-ins from the plug-in pool to the work\nflow component, and see the analysis result.\n\n  Users can use this GUI demo program by following procedure:\n\n  1. Browse the plug-ins in the plug-in pool. The brief information about the selected plug-in will be\n    displayed so that you can refer the information when set the work flow up.\n\n  2. Drag and drop plug-ins from the plug-in pool to the list in the work flow considering the phase\n    and type of the plug-in.\n     - If you want to remove the plug-in on the work flow, simply double click it.\n     - If you change the order of the supplement plug-ins in each phase, simply drag and drop a plug-in\n      to the position you want.\n\n  3. Once you finish to set the work flow up, choose 'Multi-thread Mode' or 'Single-thread Mode'.\n\n  4. Click 'Activate the work flow' button.\n\n  5. Type or copy-and-past text that you want to analyze into the 'Input Text' area.\n\n  6. Click 'Analyze Text' button.\n\n  7. You can see the analysis result on 'Result' area.\n\n  8. Repeat 5~7 to analyze other text with the activated work flow.\n    Or click 'Close the work flow' button and go to step 1 to set up new work flow. \n\n  Author: Sangwon Park (hudoni@world.kaist.ac.kr), CILab, SWRC, KAIST\n";
            JOptionPane.showMessageDialog(GUIDemo.this.mainFrame, helpStr);
        }

        private void initWorkflow() {
            GUIDemo.this.workflow.clear();
            String pluginName = null;
            int i = 0;
            while (i < GUIDemo.this.listModelSupplement1.size()) {
                pluginName = (String)GUIDemo.this.listModelSupplement1.get(i);
                if (pluginName.equals("InformalSentenceFilter")) {
                    GUIDemo.this.workflow.appendPlainTextProcessor(new InformalSentenceFilter(), null);
                } else if (pluginName.equals("SentenceSegmentor")) {
                    GUIDemo.this.workflow.appendPlainTextProcessor(new SentenceSegmentor(), null);
                }
                ++i;
            }
            if (GUIDemo.this.listModelMajor2.size() > 0) {
                pluginName = (String)GUIDemo.this.listModelMajor2.get(0);
                if (pluginName.equals("ChartMorphAnalyzer")) {
                    GUIDemo.this.workflow.setMorphAnalyzer(new ChartMorphAnalyzer(), "conf/plugin/MajorPlugin/MorphAnalyzer/ChartMorphAnalyzer.json");
                }
            } else {
                return;
            }
            i = 0;
            while (i < GUIDemo.this.listModelSupplement2.size()) {
                pluginName = (String)GUIDemo.this.listModelSupplement2.get(i);
                if (pluginName.equals("UnknownMorphProcessor")) {
                    GUIDemo.this.workflow.appendMorphemeProcessor(new UnknownProcessor(), null);
                } else if (pluginName.equals("SimpleMAResult09")) {
                    GUIDemo.this.workflow.appendMorphemeProcessor(new SimpleMAResult09(), null);
                } else if (pluginName.equals("SimpleMAResult22")) {
                    GUIDemo.this.workflow.appendMorphemeProcessor(new SimpleMAResult22(), null);
                }
                ++i;
            }
            if (GUIDemo.this.listModelMajor3.size() > 0) {
                pluginName = (String)GUIDemo.this.listModelMajor3.get(0);
                if (pluginName.equals("HmmPosTagger")) {
                    GUIDemo.this.workflow.setPosTagger(new HMMTagger(), "conf/plugin/MajorPlugin/PosTagger/HmmPosTagger.json");
                }
            } else {
                return;
            }
            i = 0;
            while (i < GUIDemo.this.listModelSupplement3.size()) {
                pluginName = (String)GUIDemo.this.listModelSupplement3.get(i);
                if (pluginName.equals("NounExtractor")) {
                    GUIDemo.this.workflow.appendPosProcessor(new NounExtractor(), null);
                } else if (pluginName.equals("SimplePOSResult09")) {
                    GUIDemo.this.workflow.appendPosProcessor(new SimplePOSResult09(), null);
                } else if (pluginName.equals("SimplePOSResult22")) {
                    GUIDemo.this.workflow.appendPosProcessor(new SimplePOSResult22(), null);
                }
                ++i;
            }
        }

        private void activateWorkflow() {
            try {
                GUIDemo.this.workflow.activateWorkflow(GUIDemo.this.multiThreadMode);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            GUIDemo.this.buttonAnalysis.setEnabled(true);
            GUIDemo.this.buttonReset.setEnabled(true);
            GUIDemo.this.buttonActivate.setEnabled(false);
            GUIDemo.this.radioMultiThread.setEnabled(false);
            GUIDemo.this.radioSingleThread.setEnabled(false);
            GUIDemo.this.listPluginSupplement1.setEnabled(false);
            GUIDemo.this.listPluginSupplement2.setEnabled(false);
            GUIDemo.this.listPluginSupplement3.setEnabled(false);
            GUIDemo.this.listPluginMajor2.setEnabled(false);
            GUIDemo.this.listPluginMajor3.setEnabled(false);
            GUIDemo.this.activated = true;
        }

        private void analyzeText() {
            String text = GUIDemo.this.inputTextArea.getText();
            if (text != null && text.length() > 0) {
                GUIDemo.this.workflow.analyze(GUIDemo.this.inputTextArea.getText());
                GUIDemo.this.outputTextArea.setText(GUIDemo.this.workflow.getResultOfDocument());
                GUIDemo.this.buttonReset.setEnabled(true);
                GUIDemo.this.buttonActivate.setEnabled(false);
            } else {
                GUIDemo.this.outputTextArea.setText("");
            }
        }

        private void reset() {
            GUIDemo.this.workflow.clear();
            GUIDemo.this.buttonActivate.setEnabled(true);
            GUIDemo.this.buttonAnalysis.setEnabled(false);
            GUIDemo.this.buttonReset.setEnabled(false);
            GUIDemo.this.radioMultiThread.setEnabled(true);
            GUIDemo.this.radioSingleThread.setEnabled(true);
            GUIDemo.this.listPluginSupplement1.setEnabled(true);
            GUIDemo.this.listPluginSupplement2.setEnabled(true);
            GUIDemo.this.listPluginSupplement3.setEnabled(true);
            GUIDemo.this.listPluginMajor2.setEnabled(true);
            GUIDemo.this.listPluginMajor3.setEnabled(true);
            GUIDemo.this.activated = false;
        }
    }
}

