% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotKspm.R
\name{plot.kspm}
\alias{plot.kspm}
\title{Plot Diagnostics for a kspm Object}
\usage{
\method{plot}{kspm}(x, which = c(1:3, 5), cook.levels = c(0.5, 1),
  id.n = 3, labels.id = names(x$residuals), cex.id = 0.75,
  col.id = "blue", ...)
}
\arguments{
\item{x}{an object of class "kspm", usually, a result of a call to \code{kspm}.}

\item{which}{if a subset of the plots is required, specify a subset of the numbers 1:5.}

\item{cook.levels}{levels of Cook's distance at which to draw contours.}

\item{id.n}{number of points to be labelled in each plot, starting with the most extreme.}

\item{labels.id}{vector of labels, from which the labels for extreme points will be chosen. NULL uses names associated to response specified in \code{kspm}.}

\item{cex.id}{size of point labels.}

\item{col.id}{color of point labels.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
Five plots (selectable by \code{which}) are currently available: a plot of residuals against fitted values, a scale Location plot of \eqn{\sqrt{\mid residuals \mid}}{sqrt(| residuals |)} against fitted values, a Normal Q Q plot for residuals, a plot of Cook's distances versus row labels and a plot of residuals against leverages. By default, the first three and 5 are provided.
}
\examples{
x <- 1:15
z1 <- runif(15, 1, 6)
z2 <- rnorm(15, 1, 2)
y <- 3*x + (z1 + z2)^2 + rnorm(15, 0, 2)
fit <- kspm(y, linear = ~ x, kernel = ~ Kernel(~ z1 + z2,
kernel.function = "polynomial", d= 2, rho = 1, gamma = 0))
plot(fit)

}
\references{
Kim, Choongrak, Byeong U. Park, and Woochul Kim. "Influence diagnostics in semiparametric regression models." Statistics and probability letters 60.1 (2002): 49:58.
}
\seealso{
\link{kspm} for fitting the model, \link{summary.kspm} for summary
}
\author{
Catherine Schramm, Aurelie Labbe, Celia Greenwood
}
