/*
 * Decompiled with CFR 0.152.
 */
package org.omegahat.Environment.Debugger.ParserViewer;

import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import org.omegahat.Environment.Debugger.ParserViewer.ExpressionTraceTree;
import org.omegahat.Environment.Parser.Parse.BasicExpression;
import org.omegahat.Graphics.Utils.ColorTable;

public class ExpressionTreeRenderer
implements TreeCellRenderer {
    protected ColorTable colorTable;
    protected Icon icon;

    public Color color(Object object) {
        return this.colorTable().getColor(object.getClass());
    }

    public ColorTable colorTable() {
        if (this.colorTable == null) {
            this.colorTable(new ColorTable(this.getClass().getResourceAsStream("colorProperties")));
        }
        return this.colorTable;
    }

    public ColorTable colorTable(ColorTable colorTable) {
        this.colorTable = colorTable;
        return this.colorTable();
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        ExpressionTraceTree expressionTraceTree = (ExpressionTraceTree)jTree;
        JLabel jLabel = new JLabel();
        String string = "";
        if (bl2) {
            string = object.getClass().getName();
            int n2 = string.lastIndexOf(46);
            if (n2 > -1) {
                string = string.substring(n2, string.length());
            }
        } else {
            string = object instanceof BasicExpression ? ((BasicExpression)object).render(bl2) : object.getClass().getName();
        }
        jLabel.setText(string);
        Color color = this.color(object);
        if (color != null) {
            jLabel.setForeground(color);
        } else {
            System.err.println("No color for class " + object.getClass());
        }
        if (expressionTraceTree.visited().contains(object)) {
            jLabel.setIcon(this.icon());
        }
        return jLabel;
    }

    public Icon icon() {
        if (this.icon == null) {
            this.icon = new ImageIcon(String.valueOf(System.getProperty("OMEGA_HOME")) + "/Environment/Images/check.gif");
        }
        return this.icon;
    }
}

