\name{MRPCA}
\alias{MRPCA}
\title{Modified regularized PCA}
\description{Caculate the estimator on the MRPCA method}
\usage{
MRPCA(data = 0, data0, real = TRUE, example = FALSE)
}
\arguments{
  \item{data}{is the orignal data set}
  \item{data0}{is the missing data set}
  \item{real}{is to judge whether the data set is a real missing data set}
  \item{example}{is to judge whether the data set is a simulation example}
}
\value{
\item{XMRPCA}{is the estimator on the MRPCA method}
  \item{MSEMRPCA}{is the MSE value of the MRPCA method}
  \item{MAEMRPCA}{is the MAE value of the MRPCA method}
  \item{REMRPCA}{is the RE value of the MRPCA method}
  \item{GCVMRPCA}{is the GCV value of the MRPCA method}
  \item{timeMRPCA}{is the time cost of the MRPCA method}
}
\examples{
 library(MASS)   
 n=100;p=10;per=0.1
 X0=data=matrix(mvrnorm(n*p,0,1),n,p)
 m=round(per*n*p,digits=0)
 mr=sample(1:(n*p),m,replace=FALSE)
 X0[mr]=NA;data0=X0
 MRPCA(data=data,data0=data0,real=FALSE,example=FALSE)
}