% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cWhittleMatern.R
\name{cWhittleMatern}
\alias{cWhittleMatern}
\title{Computes the Whittle-Matern correlation function.}
\usage{
cWhittleMatern(x, range, nu, kappa = sqrt(8 * nu)/range)
}
\arguments{
\item{x}{distance.}

\item{range}{practical range (our prefered parametrization) given as
range = sqrt(8 * nu) / kappa,
where kappa is the scale parameter in the specialized references.}

\item{nu}{process smoothness parameter.}

\item{kappa}{scale parameter, commonly considered in the specialized literature.}
}
\value{
the correlation.
}
\description{
This computes the correlation function as derived in Matern model,
see Matern (1960) eq. (2.4.7).
For nu=1, see Whittle (1954) eq. (68).
For the limiting case of nu=0, see Besag (1981) eq. (14-15).
}
\section{Details}{


Whittle, P. (1954) On Stationary Processes in the Plane.
Biometrika, Vol. 41, No. 3/4, pp. 434-449.
http://www.jstor.org/stable/2332724

Matern, B. (1960) Spatial Variation: Stochastic models and their application to
some problems in forest surveys and other sampling investigations. PhD Thesis.

Besag, J. (1981) On a System of Two-Dimensional Recurrence Equations.
JRSS-B, Vol. 43 No. 3, pp. 302-309. https://www.jstor.org/stable/2984940
}

\examples{
plot(function(x) cWhittleMatern(x, 1, 5), bty='n', las=1,
      xlab='Distance', ylab='Correlation')
plot(function(x) cWhittleMatern(x, 1, 1), add=TRUE, lty=2)
plot(function(x) cWhittleMatern(x, 1, 0.5), add=TRUE, lty=3)
abline(h=0.139, lty=3, col=gray(0.5,0.5))
}
