% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_pcawg.R
\name{convert_pcawg}
\alias{convert_pcawg}
\title{Convert PCAWG Identifiers}
\usage{
convert_pcawg(
  x,
  from = "icgc_specimen_id",
  to = "icgc_donor_id",
  db = c("full", "simple"),
  multiple = FALSE
)
}
\arguments{
\item{x}{A character vector to convert.}

\item{from}{Which identifier type to be converted.
For db "full", one of .
For db "simple", one of .}

\item{to}{Identifier type convert to. Same as parameter \code{from}.}

\item{db}{Database, one of "full" (for \code{data("pcawg_full")}) or
"simple" (for \code{data("pcawg_simple")}).}

\item{multiple}{if \code{TRUE}, return a \code{data.table} instead of a
string vector, so multiple identifier mappings can be kept.}
}
\value{
A character vector.
}
\description{
Run \code{data("pcawg_full")} or \code{data("pcawg_simple")} to see detail database for conversion.
The \code{pcawg_simple} database only contains PCAWG white-list donors.
}
\examples{
x <- convert_pcawg("SP1677")
x

y <- convert_pcawg("DO804",
  from = "icgc_donor_id",
  to = "icgc_specimen_id", multiple = TRUE
)
y
\dontrun{
convert_pcawg("SA5213")
}
}
