% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNetworkModel.R
\name{writeNetworkModel}
\alias{writeNetworkModel}
\title{Generate JAGS Code for a Network's Model}
\usage{
writeNetworkModel(network, pretty = FALSE)
}
\arguments{
\item{network}{an object of class \code{HydeNetwork}}

\item{pretty}{Logical. When \code{TRUE}, the model is printed to the console
using the \code{cat} function (useful if you wish to copy and paste the 
code for manual editing).  Otherwise, it is returned as a character 
string.}
}
\description{
Based on the parameters given to a network, the code for 
  each node is generated and all of the node models are pasted into a 
  single JAGS model script.
}
\examples{
data(PE, package='HydeNet')
Net <- HydeNetwork(~ wells + 
                     pe | wells + 
                     d.dimer | pregnant*pe + 
                     angio | pe + 
                     treat | d.dimer*angio + 
                     death | pe*treat,
                     data = PE)

#* Default printing
writeNetworkModel(Net)

#* Something a little easier on the eyes.
writeNetworkModel(Net, pretty=TRUE)

}
\seealso{
\code{\link{writeJagsModel}}, \code{\link{writeJagsFormula}}
}
\author{
Jarrod Dalton and Benjamin Nutter
}
