% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBPC.R
\name{plotBPC}
\alias{plotBPC}
\title{plotBPC.}
\usage{
plotBPC(
  bpc = NULL,
  mfrow = NULL,
  skip_plots = NULL,
  ylim = NULL,
  col = NULL,
  ids = NULL,
  type = "both"
)
}
\arguments{
\item{bpc}{A bpc object (list of intensity matrixes, rt x mz, including several attributes as attached by \link{getMultipleBPC}).}

\item{mfrow}{Specify mfrow explicitely (is optimized internally if NULL to cover n=length(bpc)).}

\item{skip_plots}{Allows to block certain subplots in the mfrow matrix to bettern align replicates.}

\item{ylim}{Can be specified specifically, will be adjusted to overall min/max otherwise.}

\item{col}{Specific color vector for masses may be provided.}

\item{ids}{Specific plot ids may be explicitely provided.}

\item{type}{Switch between co-plot of BPC and Spectrum ("both") or BPC alone ("bpc").}
}
\value{
A plot to the graphics device and NULL as invisible.
}
\description{
\code{plotBPC} will plot for each item of a list of result-ojects from \link{getMultipleBPC} the BPC traces and the spectrum at the scan where the summed intensity of all ions is max.
}
\details{
not yet
}
\examples{
# load example raw data
data(res_list)
plotBPC(bpc = res_list[[1]][["bpc"]][c(1:2, 13:14)])

}
