/*
 * Decompiled with CFR 0.152.
 */
package com.microstar.xml.demo;

import com.microstar.xml.demo.XmlApp;
import java.util.Enumeration;

public class DtdDemo
extends XmlApp {
    public static void main(String[] stringArray) throws Exception {
        DtdDemo dtdDemo = new DtdDemo();
        if (stringArray.length != 1) {
            System.err.println("Usage: java DtdDemo <uri>");
            System.exit(1);
        } else {
            dtdDemo.doParse(stringArray[0]);
        }
    }

    public void startDocument() {
        this.displayText("<-- Start of DTD -->\n");
    }

    public void endDocument(int n) {
        this.displayText("<-- End of DTD -->");
    }

    public void doctypeDecl(String string, String string2, String string3) {
        this.dumpNotations();
        this.dumpEntities();
        this.dumpElements();
    }

    public void dumpNotations() {
        Enumeration enumeration = this.parser.declaredNotations();
        this.displayText("<-- Notation Declarations -->\n");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.makeExternalIdentifiers(this.parser.getNotationPublicId(string), this.parser.getNotationSystemId(string).toString());
            this.displayText("<!NOTATION " + string + 32 + string2 + ">\n");
        }
    }

    public void dumpEntities() {
        Enumeration enumeration = this.parser.declaredEntities();
        this.displayText("<-- Entity Declarations -->\n");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.startsWith("%")) continue;
            String string2 = null;
            switch (this.parser.getEntityType(string)) {
                case 1: {
                    string2 = this.makeLiteral(this.parser.getEntityValue(string));
                    break;
                }
                case 2: {
                    string2 = this.makeExternalIdentifiers(this.parser.getEntityPublicId(string), this.parser.getEntitySystemId(string).toString()) + "NDATA " + this.parser.getEntityNotationName(string);
                    break;
                }
                case 3: {
                    string2 = this.makeExternalIdentifiers(this.parser.getEntityPublicId(string), this.parser.getEntitySystemId(string).toString());
                }
            }
            this.displayText("<!ENTITY " + string + ' ' + string2 + ">\n");
        }
    }

    public void dumpElements() {
        Enumeration enumeration = this.parser.declaredElements();
        this.displayText("<-- Element Type Declarations -->\n");
        while (enumeration.hasMoreElements()) {
            String string = "ANY";
            String string2 = (String)enumeration.nextElement();
            switch (this.parser.getElementContentType(string2)) {
                case 2: {
                    string = "EMPTY";
                    break;
                }
                case 1: {
                    string = "ANY";
                    break;
                }
                case 3: 
                case 4: {
                    string = this.parser.getElementContentModel(string2);
                }
            }
            this.displayText("<!ELEMENT " + string2 + ' ' + string + ">");
            this.dumpAttributes(string2);
            this.displayText("");
        }
    }

    public void dumpAttributes(String string) {
        Enumeration enumeration = this.parser.declaredAttributes(string);
        if (enumeration == null) {
            return;
        }
        this.displayText("<!ATTLIST " + string);
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = this.makeAttributeType(string, string2);
            String string4 = this.makeAttributeValue(string, string2);
            this.displayText("  " + string2 + ' ' + string3 + ' ' + string4);
        }
        this.displayText(">");
    }

    public String makeAttributeType(String string, String string2) {
        switch (this.parser.getAttributeType(string, string2)) {
            case 1: {
                return "CDATA";
            }
            case 2: {
                return "ID";
            }
            case 3: {
                return "IDREF";
            }
            case 4: {
                return "IDREFS";
            }
            case 5: {
                return "ENTITY";
            }
            case 6: {
                return "ENTITIES";
            }
            case 7: {
                return "NMTOKEN";
            }
            case 8: {
                return "NMTOKENS";
            }
            case 9: {
                return this.parser.getAttributeEnumeration(string, string2);
            }
            case 10: {
                return "NOTATION " + this.parser.getAttributeEnumeration(string, string2);
            }
        }
        return null;
    }

    public String makeAttributeValue(String string, String string2) {
        switch (this.parser.getAttributeDefaultValueType(string, string2)) {
            case 2: {
                return "#IMPLIED";
            }
            case 1: {
                return this.makeLiteral(this.parser.getAttributeDefaultValue(string, string2));
            }
            case 3: {
                return "#REQUIRED";
            }
            case 4: {
                return "#FIXED " + this.makeLiteral(this.parser.getAttributeDefaultValue(string, string2));
            }
        }
        return null;
    }

    public String makeExternalIdentifiers(String string, String string2) {
        String string3 = "";
        if (string != null) {
            string3 = "PUBLIC " + this.makeLiteral(string);
            if (string2 != null) {
                string3 = string3 + ' ' + this.makeLiteral(string2);
            }
        } else {
            string3 = "SYSTEM " + this.makeLiteral(string2);
        }
        return string3;
    }

    public String makeLiteral(String string) {
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('\"');
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\"') {
                stringBuffer.append("&#22;");
                continue;
            }
            if (cArray[i] > '\u007f') {
                stringBuffer.append("&#" + cArray[i] + ";");
                continue;
            }
            stringBuffer.append(cArray[i]);
        }
        stringBuffer.append('\"');
        return stringBuffer.toString();
    }
}

