% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ForecastHMMPdf.R
\name{ForecastHMMPdf}
\alias{ForecastHMMPdf}
\title{Density function of a Gaussian HMM at time n+k}
\usage{
ForecastHMMPdf(x, mu, sigma, Q, eta, k)
}
\arguments{
\item{x}{points at which the density function is comptuted (mx1);}

\item{mu}{vector of means for each regime (r x 1);}

\item{sigma}{vector of standard deviations for each regime (r x 1);}

\item{Q}{transition probality matrix (r x r);}

\item{eta}{vector of the estimated probability of each regime (r x 1) at time n;}

\item{k}{time of prediction.}
}
\value{
\item{f}{values of the density function at time n+k}

\item{w}{weights of the mixture}
}
\description{
This function computes the density function of a Gaussian HMM
at time n+k, given observation up to time n.
}
\examples{
mu <- c(-0.3 ,0.7) ; sigma <- c(0.15,0.05); Q <- matrix(c(0.8, 0.3, 0.2, 0.7),2,2) ;
eta <- c(.9,.1);
x <- seq(-1, 1, by = 0.01)
out <- ForecastHMMPdf(x,mu,sigma,Q,eta,3)
plot(x,out$f,type="l")

}
\references{
Chapter 10.2 of B. Rémillard (2013). Statistical Methods for Financial Engineering,
Chapman and Hall/CRC Financial Mathematics Series, Taylor & Francis.
}
\author{
Bouchra R Nasri  and Bruno N Rémillard, January 31, 2019
}
