% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utilities.R
\name{nzLog10}
\alias{nzLog10}
\title{nzLog10}
\usage{
nzLog10(x, quiet = FALSE, pseudocount_frxn = 0.5)
}
\arguments{
\item{x}{A numerical vector containing non-negative values.}

\item{quiet}{A boolean that tells the script to suppress warning messages. (default: FALSE. This
does not suppress errors, however.)}

\item{pseudocount_frxn}{A numerical value that sets the added pseudocount as a fraction of the
minimum non-zero value. (default: 0.5)}
}
\value{
A vector containing transformed values.
}
\description{
Utility function to safely (non-zero) log10 transform p-values that are bounded at
0, and may be zero or may be rounded to zero in certain contexts. To get around this, prior to
applying a log10 transformation the function adds a very small pseudocount to all the values if
any are detected to be zero. This avoids the generation of negative infinities. (See details, below.)
}
\details{
Prior to log10 transformation, this function first scans for any zeros in the input vector.
If it finds any, it warns that zeros have been detected in the raw statistic, and that a pseudocount
will be added. To do this the function adds a fraction of the minimum non-zero value to the values
in x. (The old version of this function, \code{nzLog10.old()} determined the value of the pseudocount
in a much more complex way. This is a simplification here.)
}
\examples{

p_vals <- c( 0.5, 0.001, 0.00001, 5e-19, 6.24e-23, 0 )
nzLog10( p_vals )

}
