% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsn.transcripts.plot.R
\name{lsn.transcripts.plot}
\alias{lsn.transcripts.plot}
\title{Lesions Gene Transcripts Plot}
\usage{
lsn.transcripts.plot(
  grin.res,
  genome,
  gene = NULL,
  transTrack = TRUE,
  lsn.clrs = NULL,
  chrom = NULL,
  plot.start = NULL,
  plot.end = NULL,
  lesion.grp = NULL,
  spec.lsn.clr = NULL,
  extend.left = NULL,
  extend.right = NULL,
  expand = 5e-04,
  hg38.transcripts = NULL,
  hg19.cytoband = NULL,
  hg38.cytoband = NULL
)
}
\arguments{
\item{grin.res}{GRIN results (output of the grin.stats function).}

\item{genome}{either "hg19" or "hg38" genome assemblies can be specified based on the genome assembly that has been used to prepare the lesion data.}

\item{gene}{Gene name of interest.}

\item{transTrack}{In case of plots that span large genomic region such as a chromosome band or the whole chromosome, this argument should be specified as 'FALSE' to exclude the transcripts track from the plot.}

\item{lsn.clrs}{Lesion colors for the regional gene plot (If not provided by the user, colors will be automatically assigned using default.grin.colors function).}

\item{chrom}{chromosome number (should be only specified in the locus plots where plot.start and plot.end for the locus of interest are specified).}

\item{plot.start}{start position of the locus of interest.}

\item{plot.end}{end position of the locus of interest.}

\item{lesion.grp}{lesion group of interest (should be only specified in locus plots when chrom, plot.start, plot.end are specified).}

\item{spec.lsn.clr}{color assigned to the lesion of interest (should be specified when chrom, plot.start, plot.end and lesion.grp are specified).}

\item{extend.left}{specified number will be used to manually align the left side of the gene transcripts track directly retrieved from ensembl database with the gene lesions track if needed.}

\item{extend.right}{specified number will be used to manually align the right side of the gene transcripts track directly retrieved from ensembl database with the gene lesions track if needed.}

\item{expand}{Controls ratio of the gene locus (start and end position) to the whole plot with default value = 0.0005 (setting expand=0 will only plot the gene locus from the start to the end position without any of the upstream or downstream regions of the gene).}

\item{hg38.transcripts}{transcripts data retrieved from annotation hub for hg38 version 110 (should be only specified if genome="hg38").}

\item{hg19.cytoband}{hg19 chromosome bands start and end data in base pair (should be only specified if genome="hg19").}

\item{hg38.cytoband}{hg38 chromosome bands start and end data in base pair (should be only specified if genome="hg38").}
}
\value{
Function will return either a gene plot with the transcripts track, lesions panel and GRIN statistic for the gene of interest, a plot with all lesions and transcripts aligned to a certain locus of interest if chrom, plot.start and plot.end were specified or a plot with all lesions affecting a region of interest without the transcripts track.
}
\description{
Function prepare a plot with all types of lesions that spans either a gene or a region of interest.
}
\details{
Function return a plot with all lesions that affect either a gene or a region of interest. Top panel of the regional gene plot has the transcripts track with all transcripts annotated to the gene of interest directly retrieved from ensembl database. The middle panel will has all different types of lesions affecting the gene color coded according to the figure legend. Lower panel of the plot has all the GRIN statistics of the gene that include number of subjects affected by each type of lesions, -log10 p, and –log10q values showing if the gene is significantly affected by the corresponding lesion category. If a certain locus is specified, only transcripts track and the lesion panel will be returned (GRIN results panel will not be added to the plot). In case of plots that span large genomic region such as a chromosome band or the whole chromosome and by specifying transTrack=FALSE, transcripts track will not be added to the plot as well.
}
\examples{
\donttest{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)
data(hg19_cytoband)
data(hg38_cytoband)

# run GRIN analysis using grin.stats function
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)

# Plots showing different types of lesions affecting a gene of interest with a transcripts
# track that show all the gene transcripts retrieved from Ensembl (hg19 genome assembly):
WT1.gene.plot=lsn.transcripts.plot(grin.results, genome="hg19", gene="WT1",
                                    hg19.cytoband=hg19_cytoband)

# Plots showing different types of lesions affecting a region of interest with a transcripts
# track added to the plot:
locus.plot=lsn.transcripts.plot(grin.results, genome="hg19", hg19.cytoband=hg19_cytoband,
                                chrom=9, plot.start=21800000, plot.end=22200000,
                                lesion.grp = "loss", spec.lsn.clr = "blue")

# Plots Showing Different Types of Lesions Affecting a region of Interest without plotting the
# transcripts track (this will allow plotting a larger locus of the chromosome such as a
# chromosome band (should specify transTrack = FALSE):
noTranscripts=lsn.transcripts.plot(grin.results, genome="hg19", transTrack = FALSE,
                                   hg19.cytoband=hg19_cytoband, chrom=9, plot.start=19900000,
                                   plot.end=25600000, lesion.grp = "loss", spec.lsn.clr = "blue")

 # Plots Showing Different Types of Lesions Affecting the whole chromosome:
 chrom.plot=lsn.transcripts.plot(grin.results, genome="hg19", transTrack = FALSE,
                                 hg19.cytoband=hg19_cytoband, chrom=9, plot.start=1,
                                  plot.end=141000000)

# for GRCh38 (hg38) genome assembly, users should first call the AnnotationHub() web resource then
# specify ah[["AH113665"]] to retrieve the human hg38 gene transcripts. This formal class
# EnsDb object should be called afterwards in the 'hg38.transcripts' argument to return gene and
# regional plots.
}
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=grin.stats]{grin.stats()}}
}
\author{
{Abdelrahman Elsayed \email{abdelrahman.elsayed@stjude.org} and Stanley Pounds \email{stanley.pounds@stjude.org}}
}
