% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CorrMat.R
\name{CorrMat}
\alias{CorrMat}
\title{The Function for Constructing the Correlation Matrix in \code{GPM} Package}
\usage{
CorrMat(X1, X2, CorrType, Omega)
}
\arguments{
\item{X1, X2}{Matrices containing the data points. The rows and columns of both \code{X1} and \code{X2} denote individual observation settings and dimension, respectively.}

\item{CorrType}{The correlation function of the GP model. Choices include \code{'G'} (default), \code{'PE'}, \code{'LBG'}, and \code{'LB'}. See the \code{references} for the details.}

\item{Omega}{The vector storing all the scale (aka roughness) parameters of the correlation function. The length of \code{Omega} depends on the \code{CorrType}. See \code{reference 1}.}
}
\value{
R The Correlation matrix with size \code{nrow(X1)}-by-\code{nrow(X2)}. See \href{https://en.wikipedia.org/wiki/Correlation_matrix}{here}.
}
\description{
Builds the correlation matrix given two datasets, and the type and parameters of the correlation function.
}
\note{
This function is \strong{NOT} exported once the GPM package is loaded.
}
\examples{
# see the examples in \\code{\\link[GPM]{Fit}}
}
\references{
\enumerate{
\item Bostanabad, R., Kearney, T., Tao, S., Apley, D. W. & Chen, W. Leveraging the nugget parameter for efficient Gaussian process modeling. International Journal for Numerical Methods in Engineering, doi:10.1002/nme.5751.
\item M. Plumlee, D.W. Apley (2016). Lifted Brownian kriging models, Technometrics.
}
}
\seealso{
\code{\link[GPM]{Fit}} to see how a GP model can be fitted to a training dataset.\cr
\code{\link[GPM]{Predict}} to use the fitted GP model for prediction.\cr
\code{\link[GPM]{Draw}} to plot the response via the fitted model.
}
