% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_noise_gp.R
\name{estimate_noise_gp}
\alias{estimate_noise_gp}
\title{Estimate the Standard Deviation of the Nugget Term in Full Gaussian Process}
\usage{
estimate_noise_gp(hyperparam, data, GPS)
}
\arguments{
\item{hyperparam}{A vector of hyper-parameter values for the full GP.}

\item{data}{A data.table of observation data.
\itemize{
\item Column 1: Outcome (Y)
\item Column 2: Exposure or treatment (w)
\item Column 3~m: Confounders (C)
}}

\item{GPS}{A vector of estimated GPS at the observed exposure levels.}
}
\value{
A scalar of estimated standard deviation of the nugget term in full GP.
}
\description{
Estimates the standard deviations of the nugget term in full GP by
calculating the standard deviations of the residuals.
}
\examples{

set.seed(109)
data <- generate_synthetic_data(sample_size = 100, gps_spec = 3)
data.table::setDT(data)

# Estimate GPS function
GPS_m <- train_GPS(cov_mt = as.matrix(data[,-(1:2)]),
                   w_all = as.matrix(data$treat))

hyperparam <- c(0.1, 0.2, 1)

noise_est <- estimate_noise_gp(hyperparam, data, GPS_m$GPS)


}
