% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{dmvnormal}
\alias{dmvnormal}
\alias{rmvnormal}
\title{Multivariate Gaussian density and simulation}
\usage{
dmvnormal(x, mu, sigma)

rmvnormal(n, mu, sigma)
}
\arguments{
\item{x}{A \code{p} times \code{k} matrix of quantiles. Each rows
correspond to a realization from the density and each column corresponds
to a dimension.}

\item{mu}{The mean vector of dimension \code{k}.}

\item{sigma}{The variance-covariance matrix of dimension \code{k} times
\code{k}.}

\item{n}{The number of observations to be simulated.}
}
\value{
\code{dmvnormal} returns a \eqn{1} by \eqn{p} matrix of the
  probability densities corresponding to each row of \code{x}.
\code{sigma}. Each row corresponds to an observation.

\code{rmvnormal} returns a \code{p} by \code{k} matrix of
  observations from a multivariate normal distribution with the given mean
  \code{mu} and covariance
}
\description{
Fast simulation from and evaluation of multivariate Gaussian probability
densities.
}
\details{
\code{dmvnormal} functions similarly to \code{dmvnorm} from the
\code{mvtnorm}-package and likewise for \code{rmvnormal} and
\code{rmvnorm}.
}
\examples{
dmvnormal(x = matrix(rnorm(300), 100, 3),
          mu = 1:3,
          sigma = diag(3))
rmvnormal(n = 10, mu = 1:4, sigma = diag(4))
}
\seealso{
\code{dmvnorm} and \code{rmvnorm} in the \code{mvtnorm}-package.
}
\author{
Anders Ellern Bilgrau
}
