% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_checklists_conditional.R
\name{GIFT_checklists_conditional}
\alias{GIFT_checklists_conditional}
\title{GIFT checklists meta data}
\usage{
GIFT_checklists_conditional(
  taxon_name = "Tracheophyta",
  floristic_scope = c("all", "native", "native and naturalized",
    "native and historically introduced", "endangered", "endemic", "naturalized",
    "other subset")[1:4],
  ref_excluded = NULL,
  type_ref = c("Account", "Catalogue", "Checklist", "Flora", "Herbarium collection",
    "Key", "Red list", "Report", "Species Database", "Survey"),
  entity_class = c("Island", "Island/Mainland", "Mainland", "Island Group",
    "Island Part"),
  native_indicated = FALSE,
  natural_indicated = FALSE,
  end_ref = FALSE,
  end_list = FALSE,
  suit_geo = FALSE,
  complete_taxon = TRUE,
  GIFT_version = "latest",
  api = "https://gift.uni-goettingen.de/api/extended/",
  list_set = NULL,
  taxonomy = NULL
)
}
\arguments{
\item{taxon_name}{Character string corresponding to the taxonomic group
of interest.}

\item{floristic_scope}{A vector listing floristic scopes of the references
to be considered.
Options are: \code{all}, \code{native}, \verb{native and naturalized},
\verb{native and historically introduced}, \code{endangered}, \code{endemic},
\code{naturalized}, \verb{other subset}.}

\item{ref_excluded}{A vector listing potential ref_IDs that shall be ignored
when assembling the set of regions and checklists fulfilling the given
criteria. Checklists from these references will not be returned. \code{NULL} by
default.}

\item{type_ref}{Character, options are \code{Account}, \code{Catalogue}, \code{Checklist},
\code{Flora}, \verb{Herbarium collection}, \code{Key}, \verb{Red list}, \code{Report},
\verb{Species Database}, \code{Survey}.}

\item{entity_class}{Character, options are \code{Island}, \code{Island/Mainland},
\code{Mainland}, \verb{Island Group}, \verb{Island Part}.}

\item{native_indicated}{Logical, whether only lists where native status
is available should be retrieved.}

\item{natural_indicated}{Logical, whether only lists where natural status
is available should be retrieved.}

\item{end_ref}{Logical, whether only lists where endemism at the reference
level is available should be retrieved.}

\item{end_list}{Logical, whether only lists where endemism at the list level
is available should be retrieved.}

\item{suit_geo}{logical indicating whether only regions classified as
suit_geo should be considered (see details).}

\item{complete_taxon}{Logical, default \code{TRUE}.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{list_set}{list_set \code{NULL} by default. If not, it has to be the list
table (see \code{\link[=GIFT_lists]{GIFT_lists()}}). Used internally in
\code{\link[=GIFT_checklists]{GIFT_checklists()}} to avoid downloading the table of lists many times.}

\item{taxonomy}{default \code{NULL}. If not, it has to be the taxonomy table
(see \code{\link[=GIFT_taxonomy]{GIFT_taxonomy()}}).}
}
\value{
A data frame with 16 columns.
}
\description{
Retrieve meta data of GIFT checklists for regions that are covered by
checklists jointly fulfilling specific criteria.
}
\details{
Here is what each column refers to:

\emph{ref_ID} - Identification number of each reference.\cr
\emph{type} - What type the source is.\cr
\emph{subset} - What information regarding the status of species is
available.\cr
\emph{native_indicated} - Whether native status of species is available in
the source.\cr
\emph{natural_indicated} - Whether naturalized status of species is
available in the source.\cr
\emph{end_ref} - Whether endemism information is available in the source.\cr
\emph{restricted} - Whether the access to this reference is restricted.\cr
\emph{taxon_ID} - Identification number of species.\cr
\emph{list_ID} - Identification number of each list.\cr
\emph{end_list} - Whether endemism information is available in the list.\cr
\emph{entity_ID} - Identification number of the polygon of the list.\cr
\emph{geo_entity} - Name of the location.\cr
\emph{suit_geo} - Is the polygon suitable.\cr
\emph{entity_class} - Type of polygon.\cr
\emph{entity_type} - Name of the location.\cr
\emph{taxon_name} - Name of the group of taxa available.
}
\examples{
\donttest{
ex <- GIFT_checklists_conditional(taxon_name = "Embryophyta", 
floristic_scope = c("all", "native", "native and naturalized",
"native and historically introduced", "endangered",
"endemic", "naturalized", "other subset")[7],
type_ref = c("Account", "Catalogue", "Checklist","Flora",
"Herbarium collection", "Key", "Red list", "Report", "Species Database",
 "Survey"),
 entity_class = c("Island", "Island/Mainland", "Mainland", "Island Group",
 "Island Part"),
 native_indicated = FALSE, natural_indicated = FALSE, end_ref = FALSE,
 end_list = FALSE, suit_geo = TRUE, complete_taxon = TRUE,
 list_set = NULL, taxonomy = NULL)

}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Denelle, P., Weigelt, P., & Kreft, H. (2023). GIFT—An R package to
 access the Global Inventory of Floras and Traits. Methods in Ecology
 and Evolution, 14, 2738-2748.
 https://doi.org/10.1111/2041-210X.14213

 Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists_raw]{GIFT_checklists_raw()}}
}
