% Generated by roxygen2 (4.0.2): do not edit by hand
\name{+.gg}
\alias{+.gg}
\title{Modify a ggpairs object by adding an ggplot2 object to all plots}
\usage{
\method{+}{gg}(e1, e2)
}
\arguments{
\item{e1}{An object of class \code{ggplot} or \code{theme}}

\item{e2}{A component to add to \code{e1}}
}
\description{
This operator allows you to add ggplot2 objects to a ggpairs object.
}
\details{
If the first object is an object of class \code{ggpairs}, you can add
the following types of objects, and it will return a modified ggplot
object.

\itemize{
  \item \code{theme}: update plot theme
}

The \code{+} operator completely replaces elements
with elements from e2.
}
\examples{
data(tips, package = "reshape")
pm <- ggpairs(tips[,2:3])
## change to black and white theme
pm + ggplot2::theme_bw()
## change to linedraw theme
# pm + ggplot2::theme_linedraw()
## change to custom theme
# pm + ggplot2::theme(panel.background = ggplot2::element_rect(fill = "lightblue"))
}
\seealso{
\code{\link[ggplot2]{+.gg}} and \code{\link[ggplot2]{theme}}
}

