% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gemInputOutputTable_Leontief_3_3.R
\name{gemInputOutputTable_Leontief_3_3}
\alias{gemInputOutputTable_Leontief_3_3}
\title{A Leontief-type General Equilibrium Model based on a 3x3 Input-Output Table}
\usage{
gemInputOutputTable_Leontief_3_3(
  input = matrix(c(200, 300, 100, 150, 320, 530, 250, 380, 0), 3, 3, TRUE),
  output = c(600, 1000, 630)
)
}
\arguments{
\item{input}{the input matrix in the base period.}

\item{output}{a vector consisting of the product outputs and labor supply in the base period.}
}
\value{
A general equilibrium, which is a list with the following elements:
\itemize{
\item p - the price vector with labor as numeraire.
\item D - the demand matrix, also called the input table. Wherein the benchmark prices are used.
\item DV - the demand value matrix, also called the value input table. Wherein the current price is used.
\item SV - the supply value matrix, also called the value output table. Wherein the current price is used.
\item ... - some elements returned by the CGE::sdm function
}
}
\description{
Given a 3x3 input-output table (e.g., see Zhang Xin, 2017, Table 2.2.2), this model can be
used to calculate the corresponding equilibrium.
This input-output table contains two firms and one household.
The household consumes products and supplies labor.
}
\examples{
x <- 75
gemInputOutputTable_Leontief_3_3(
  input = matrix(c(
    200, 300, 100,
    x, 320, 530,
    250, 380, 0
  ), 3, 3, TRUE),
  output = c(600, 1000, 630)
)
}
\references{
Zhang Xin. (2017, ISBN: 9787543227637). Principles of Computable General Equilibrium Modeling and Programming (Second Edition). Shanghai: Gezhi Press. (In Chinese)
}
