% Generated by roxygen2 (4.0.1): do not edit by hand
\name{exphp}
\alias{cosechp}
\alias{coshp}
\alias{cotanhp}
\alias{exphp}
\alias{sechp}
\alias{sinhp}
\alias{tanhp}
\title{Power Hyperbolas and Power Hyperbolic Functions}
\usage{
exphp(x, k = 1)

coshp(x, k = 1)

sinhp(x, k = 1)

tanhp(x, k = 1)

sechp(x, k = 1)

cosechp(x, k = 1)

cotanhp(x, k = 1)
}
\arguments{
\item{x}{a numeric value, vector or matrix.}

\item{k}{a numeric value, preferably strictly positive.}
}
\description{
These functions define the power hyperbola \code{exphp} and the associated
power hyperbolic cosine, sine, tangent, secant, cosecant, cotangent.
They are similar to the traditional hyperbolic functions with term
\code{x} receiving a nonlinear transformation via the function
\code{\link{kashp}}.
}
\details{
\code{exphp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ exphp(x, k) =  exp( kashp(x, k) )
                         =  exp( k * asinh(x / 2 / k) ) }
\code{coshp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ coshp(x, k) = cosh( kashp(x, k) ) }
\code{sinhp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ sinhp(x, k) = sinh( kashp(x, k) ) }
\code{tanhp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ tanhp(x, k) = tanh( kashp(x, k) ) }
\code{sechp} function is defined for x in (-Inf, +Inf) by:
      \deqn{ sechp(x, k) = 1 / coshp(x, k) }
\code{cosechp} function is defined for x in (-Inf, 0) U (0, +Inf) by:
      \deqn{ cosechp(x, k) = 1 / sinhp(x, k) }
\code{cotanhp} function is defined for x in (-Inf, 0) U (0, +Inf) by:
      \deqn{ cotanhp(x, k) = 1 / tanhp(x, k) }

The undesired case k = 0 returns 0 for sinhp and tanhp,
1 for exphp, coshp and sechp, Inf for cosechp and cotanhp.

If k is a vector of length > 1, then the use of the function
\code{\link[base]{outer}} is recommanded.
}
\examples{
### Example 1
x  <- (-2:3)*3
exphp(x, k = 4)
coshp(x, k = 4)
sinhp(x, k = 4)
tanhp(x, k = 4)

### Example 2
mat  <- matrix(x , ncol = 2)
exphp(mat, k = 4)
coshp(mat, k = 4)
sinhp(mat, k = 4)
tanhp(mat, k = 4)

### Example 3 outer + plot(exphp, coshp, sinhp, tanhp)
xmin  <- -10
xd    <- 0.5
x     <- seq(xmin, -xmin, xd) ; names(x) <- x
k     <- c(0.6, 1, 1.5, 2, 3.2, 10) ; names(k) <- k
olty  <- c(2, 1, 2, 1, 2, 1, 1)
olwd  <- c(1, 1, 2, 2, 3, 4, 2)
ocol  <- c(2, 2, 4, 4, 3, 3, 1)
op    <- par(mfrow = c(2,2), mgp = c(1.5,0.8,0), mar = c(3,3,2,1))

## exphp(x, k)
Texphp <- ts(cbind(outer(-x, k, exphp), "exp(-x/2)" = exp(-x/2)),
             start = xmin, deltat = xd)
plot(Texphp, plot.type = "single", ylim = c(0,20),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i", xlab = "",
       ylab = "", main = "exphp(-x, k)" )
legend("topright", title = expression(kappa), legend = colnames(Texphp),
       inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

## coshp(x, k)
Tcoshp <- ts(cbind(outer(x, k, coshp), "cosh(x/2)" = cosh(x/2)),
             start = xmin, deltat = xd)
plot(Tcoshp, plot.type = "single", ylim = c(0,20),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i",
       xlab = "", ylab = "", main = "coshp(x, k)" )
legend("top", title = expression(kappa), legend = colnames(Tcoshp),
       inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )

## sinhp(x, k)
Tsinhp <- ts(cbind(outer(x, k, sinhp), "sinh(x/2)" = sinh(x/2)),
             start = xmin, deltat=xd)
plot(Tsinhp, plot.type = "single", ylim = c(-10,10),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i",
       xlab = "", ylab = "", main = "sinhp(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Tsinhp),
       inset = 0.02, lty = olty, lwd=  olwd, col = ocol, cex = 0.7 )

## tanhp(x, k)
Ttanhp <- ts(cbind(outer(x, k, tanhp), "tanh(x/2)" = tanh(x/2)),
             start = xmin, deltat = xd)
plot(Ttanhp, plot.type = "single", ylim = c(-1,1),
       lty = olty, lwd = olwd, col = ocol, xaxs = "i", yaxs = "i", xlab = "",
       ylab = "", main = "tanhp(x, k)" )
legend("topleft", title = expression(kappa), legend = colnames(Ttanhp),
       inset = 0.02, lty = olty, lwd = olwd, col = ocol, cex = 0.7 )
### End Example 3
}
\seealso{
The nonlinear transformation \code{\link{kashp}}, the inverse power
hyperbolas and the inverse power hyperbolic functions \code{\link{loghp}}.
}

